/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.kga;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.sourceforge.kga.Animal;
import org.sourceforge.kga.Plant;
import org.sourceforge.kga.Taxon;
import org.sourceforge.kga.io.SerializableSpecies;
import org.sourceforge.kga.plant.PropertySource;

public class PlantList {
    private static Logger log = Logger.getLogger(PlantList.class.getName());
    private static Map<Integer, Plant> plants;
    private static Map<Integer, Animal> animals;
    public static SerializableSpecies serializableSpecies;
    private static PlantList resources;
    private Set<String> translations = new TreeSet<String>();
    private ArrayList<PropertySource> sources = new ArrayList();

    public PlantList() {
        plants = new TreeMap<Integer, Plant>();
        animals = new TreeMap<Integer, Animal>();
    }

    public static void initialize(InputStream inputStream) {
        try {
            serializableSpecies = new SerializableSpecies(inputStream);
            resources = serializableSpecies.getSpeciesList();
            StringBuilder stringBuilder = new StringBuilder();
            for (Plant plant : resources.getPlants()) {
                plant.getCompanions().logConflicts(stringBuilder);
            }
            log.warning(stringBuilder.toString());
        }
        catch (Exception exception) {
            log.severe(exception.toString());
            exception.printStackTrace();
            resources = new PlantList();
        }
    }

    public static PlantList getResources() {
        return resources;
    }

    public Animal getAnimal(int n) {
        return animals.get(n);
    }

    public Collection<Animal> getAnimals() {
        return animals.values();
    }

    public void addTaxon(Taxon taxon) {
        int n = taxon.getId();
        if (plants.containsKey(n) || animals.containsKey(n)) {
            log.severe("Duplicate ID=" + Integer.toString(n) + " " + taxon.getName());
        }
        if (taxon instanceof Plant) {
            plants.put(n, (Plant)taxon);
        } else if (taxon instanceof Animal) {
            animals.put(n, (Animal)taxon);
        }
    }

    public Plant getPlant(int n) {
        return plants.get(n);
    }

    public Collection<Plant> getPlants() {
        return plants.values();
    }

    public void setTranslation(int n, String string, String string2) {
        this.translations.add(string);
        Plant plant = plants.get(n);
        Animal animal = animals.get(n);
        (plant != null ? plant : animal).setTranslation(string, string2);
    }

    public Set<String> getTranslations() {
        return this.translations;
    }

    public PropertySource addSource(String string, String string2) {
        log.info("addSource " + string);
        for (int i = 0; i < this.sources.size(); ++i) {
            if (this.sources.get((int)i).name.compareTo(string) != 0) continue;
            log.info("source already added");
            return this.sources.get(i);
        }
        log.info("new source");
        this.sources.add(new PropertySource(this.sources.size() + 1, string, string2));
        return this.sources.get(this.sources.size() - 1);
    }

    public PropertySource reserveSource(int n) {
        --n;
        while (n >= this.sources.size()) {
            this.sources.add(new PropertySource(this.sources.size() + 1, "", ""));
        }
        return this.sources.get(n);
    }

    public PropertySource getSource(int n) {
        if (--n >= this.sources.size()) {
            return null;
        }
        return this.sources.get(n);
    }

    static {
        resources = null;
    }
}

