/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.kga.gui.desktop;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.sourceforge.kga.GardenObserver;
import org.sourceforge.kga.Plant;
import org.sourceforge.kga.PlantList;
import org.sourceforge.kga.Point;
import org.sourceforge.kga.Rectangle;
import org.sourceforge.kga.gui.desktop.EditableGarden;
import org.sourceforge.kga.gui.desktop.EditableGardenObserver;
import org.sourceforge.kga.gui.desktop.GardenController;
import org.sourceforge.kga.gui.desktop.GardenPanelHeaders;
import org.sourceforge.kga.rules.Hint;
import org.sourceforge.kga.rules.HintList;
import org.sourceforge.kga.rules.Rule;
import org.sourceforge.kga.translation.Translation;
import org.sourceforge.kga.wrappers.Image;

public class GardenView
extends JPanel
implements GardenObserver,
EditableGardenObserver,
Printable,
AdjustmentListener,
ChangeListener {
    private static Logger log = Logger.getLogger(GardenView.class.getName());
    private static final long serialVersionUID = 1L;
    private int year;
    private EditableGarden garden;
    private GardenController controller;
    private GardenPanelHeaders rowHeader;
    private GardenPanelHeaders columnHeader;
    BufferedImage image = null;
    BufferedImage background = null;
    JScrollPane scrollPane;
    public static final int PLANT_SIZE = 48;
    public static final int PADDING = 9;
    public static final int GRID_SIZE = 66;
    public static final int gridPrintSize = 36;
    private static Cursor cursorDelete;
    private static Cursor cursorPick;
    boolean horizontalToEnd = false;
    boolean verticalToEnd = false;
    int horizontalLastMax = -1;
    int verticalLastMax = -1;

    public GardenView(EditableGarden editableGarden, int n) {
        this.garden = editableGarden;
        this.year = n;
        this.setPreferredSize(this.getImageSize());
        this.rowHeader = new GardenPanelHeaders(1);
        this.rowHeader.setZoomFactor(this.getZoomFactor());
        this.rowHeader.setPreferredHeight(this.getHeight());
        this.columnHeader = new GardenPanelHeaders(0);
        this.columnHeader.setZoomFactor(this.getZoomFactor());
        this.columnHeader.setPreferredWidth(this.getWidth());
        this.scrollPane = new JScrollPane();
        this.scrollPane.setViewportView(this);
        this.scrollPane.getHorizontalScrollBar().setUnitIncrement(16);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(16);
        this.scrollPane.setRowHeaderView(this.rowHeader);
        this.scrollPane.setColumnHeaderView(this.columnHeader);
        this.scrollPane.getHorizontalScrollBar().getModel().addChangeListener(this);
        this.scrollPane.getVerticalScrollBar().getModel().addChangeListener(this);
        this.scrollPane.getHorizontalScrollBar().addAdjustmentListener(this);
        this.scrollPane.getVerticalScrollBar().addAdjustmentListener(this);
        editableGarden.addObserver(this);
        editableGarden.addObserver(this);
        this.controller = new GardenController();
        this.controller.setView(this);
        this.setToolTipText("123");
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
            }

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                GardenView.this.rowHeader.setPreferredHeight(GardenView.this.getHeight());
                GardenView.this.columnHeader.setPreferredWidth(GardenView.this.getWidth());
                GardenView.this.rowHeader.invalidate();
                GardenView.this.columnHeader.invalidate();
            }

            @Override
            public void componentShown(ComponentEvent componentEvent) {
            }
        });
    }

    public BufferedImage getBufferedImage() {
        return this.image;
    }

    private int getZoomFactor() {
        return this.garden.getZoomFactor();
    }

    public EditableGarden getGarden() {
        return this.garden;
    }

    public int getYear() {
        return this.year;
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    @Override
    public void zoomFactorChanged(EditableGarden editableGarden) {
        this.rowHeader.setZoomFactor(this.getZoomFactor());
        this.rowHeader.repaint();
        this.columnHeader.setZoomFactor(this.getZoomFactor());
        this.columnHeader.repaint();
        Dimension dimension = this.getImageSize();
        dimension.setSize(dimension.getWidth() * (double)this.getZoomFactor() / 100.0, dimension.getHeight() * (double)this.getZoomFactor() / 100.0);
        this.setPreferredSize(dimension);
        this.repaint();
        this.revalidate();
    }

    @Override
    public void gardenChanged(EditableGarden editableGarden) {
    }

    @Override
    public void previewSpeciesChanged(EditableGarden editableGarden, Plant plant) {
        this.background = null;
        this.repaint();
    }

    @Override
    public void operationChanged(EditableGarden editableGarden) {
        switch (editableGarden.getOperation()) {
            case AddPlant: {
                this.setCursor(Cursor.getPredefinedCursor(0));
                break;
            }
            case DeletePlant: {
                this.setCursor(cursorDelete);
                break;
            }
            case PickPlant: {
                this.setCursor(cursorPick);
            }
        }
    }

    java.awt.Rectangle getGardenBounds() {
        return new java.awt.Rectangle(this.garden.getBounds().x, this.garden.getBounds().y, this.garden.getBounds().width, this.garden.getBounds().height);
    }

    private Dimension getImageSize() {
        java.awt.Rectangle rectangle = this.getGardenBounds();
        rectangle.translate(rectangle.x < 0 ? -rectangle.x : 0, rectangle.y < 0 ? -rectangle.y : 0);
        rectangle.grow(1, 1);
        return new Dimension(rectangle.width * 66, rectangle.height * 66);
    }

    private void createBackgroundImage() {
        this.getTopLevelAncestor().setCursor(Cursor.getPredefinedCursor(3));
        Dimension dimension = this.getImageSize();
        this.background = new BufferedImage(dimension.width, dimension.height, 2);
        Graphics2D graphics2D = (Graphics2D)this.background.getGraphics();
        log.info("Create Background " + Integer.toString(this.year) + " size=" + dimension.toString());
        Plant plant = this.garden.getSelectedPlant();
        if (plant != null && !plant.isItem()) {
            Rectangle rectangle = this.garden.getBounds();
            log.info("Draw backgrounds " + rectangle.toString());
            Point point = new Point();
            point.x = rectangle.x - 1;
            while (point.x <= rectangle.width) {
                point.y = rectangle.y - 1;
                while (point.y <= rectangle.height) {
                    java.awt.Point point2 = this.GridToImageLocation(point);
                    graphics2D.translate(point2.x, point2.y);
                    this.DrawBackground(graphics2D, point);
                    graphics2D.translate(-point2.x, -point2.y);
                    ++point.y;
                }
                ++point.x;
            }
        }
        this.getTopLevelAncestor().setCursor(Cursor.getPredefinedCursor(0));
    }

    private void createImage() {
        this.getTopLevelAncestor().setCursor(Cursor.getPredefinedCursor(3));
        Dimension dimension = this.getImageSize();
        this.image = new BufferedImage(dimension.width, dimension.height, 2);
        Graphics2D graphics2D = (Graphics2D)this.image.getGraphics();
        log.info("Create Image " + Integer.toString(this.year) + " size=" + dimension.toString());
        Map map = this.garden.getAllSquares().get(this.year);
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                this.DrawSquare((Point)entry.getKey(), (List)entry.getValue(), graphics2D, false);
            }
        }
        dimension.setSize(dimension.getWidth() * (double)this.getZoomFactor() / 100.0, dimension.getHeight() * (double)this.getZoomFactor() / 100.0);
        this.setPreferredSize(dimension);
        this.getTopLevelAncestor().setCursor(Cursor.getPredefinedCursor(0));
    }

    void DrawBackground(Graphics2D graphics2D, Point point) {
        if (this.background == null) {
            return;
        }
        Map.Entry<Integer, Integer> entry = this.garden.getPreviewHints(this.year, point);
        if (entry != null) {
            int n = entry.getKey();
            int n2 = entry.getValue();
            if (n != 0 || n2 != 0) {
                if (n2 < 0) {
                    n += -n2;
                    n2 = 0;
                }
                if (n < 0) {
                    n2 += -n;
                    n = 0;
                }
                if (n > 3) {
                    n = 3;
                }
                if (n2 > 3) {
                    n2 = 3;
                }
                graphics2D.setColor(new Color((n2 >= n ? 3.0f : (float)n2) / 3.0f, (n >= n2 ? 3.0f : (float)n) / 3.0f, 0.0f, (float)(n2 > n ? n2 : n) / 3.0f));
                graphics2D.fillRect(0, 0, 66, 66);
            }
        }
    }

    void drawPreviewOutsideBounds(Graphics2D graphics2D) {
        if (this.garden.getPreviewYear() != this.year) {
            return;
        }
        java.awt.Rectangle rectangle = this.getGardenBounds();
        rectangle.grow(1, 1);
        if (rectangle.contains(this.garden.getPreviewGrid().x, this.garden.getPreviewGrid().y)) {
            return;
        }
        java.awt.Point point = this.GridToLocation(this.garden.getPreviewGrid());
        graphics2D.translate(point.x, point.y);
        graphics2D.scale((double)this.garden.getZoomFactor() / 100.0, (double)this.garden.getZoomFactor() / 100.0);
        graphics2D.setComposite(AlphaComposite.getInstance(3, 0.5f));
        java.awt.Image image = this.garden.getPreviewPlant().getImage().get();
        if (this.garden.getPreviewPlant().isItem()) {
            graphics2D.drawImage(image, 0, 0, 66, 66, this);
        } else {
            graphics2D.drawImage(image, 9, 9, 48, 48, this);
        }
        graphics2D.setPaintMode();
        graphics2D.scale(1.0, 1.0);
        graphics2D.translate(-point.x, -point.y);
    }

    void DrawSquare(Point point, List<Plant> list, Graphics2D graphics2D, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4;
        if (this.image == null) {
            return;
        }
        java.awt.Point point2 = this.GridToImageLocation(point);
        graphics2D.translate(point2.x, point2.y);
        if (bl) {
            graphics2D.setComposite(AlphaComposite.Src);
            graphics2D.setColor(new Color(255, 255, 255, 0));
            graphics2D.fillRect(0, 0, 66, 66);
            graphics2D.setPaintMode();
        }
        if (list == null || list.size() == 0) {
            graphics2D.translate(-point2.x, -point2.y);
            return;
        }
        if (list.contains(PlantList.getResources().getPlant(116))) {
            this.DrawSquareWithPath(point, graphics2D);
        } else {
            int n5 = (int)Math.sqrt(list.size());
            if (n5 * n5 < list.size()) {
                ++n5;
            }
            n4 = 48 / n5;
            int n6 = 0;
            for (n3 = 0; n3 < n5; ++n3) {
                for (n2 = 0; n2 < n5 && n6 < list.size(); ++n2, ++n6) {
                    if (list.get(n6) == null) {
                        System.err.println("species is null");
                        continue;
                    }
                    boolean bl2 = this.garden.isPreview(this.year, point, list.get(n6));
                    if (bl2) {
                        graphics2D.setComposite(AlphaComposite.getInstance(3, 0.5f));
                    }
                    int n7 = n4 * n2;
                    int n8 = n4 * n3;
                    n = n4;
                    if (list.size() == 2) {
                        n = 32;
                        if (n6 == 1) {
                            n7 = 16;
                            n8 = 16;
                        }
                    }
                    if (list.get(n6).isItem()) {
                        graphics2D.drawImage(list.get(n6).getImage().get(), n7, n8, 66, 66, this);
                    } else {
                        graphics2D.drawImage(list.get(n6).getImage().get(), 9 + n7, 9 + n8, n, n, this);
                    }
                    if (!bl2) continue;
                    graphics2D.setPaintMode();
                }
            }
        }
        HintList hintList = Rule.getHints(this.garden, this.year, point, false);
        n4 = 7;
        boolean[][] blArray = new boolean[n4][n4];
        n3 = 0;
        n2 = 0;
        for (Hint hint : hintList) {
            int n9;
            int n10;
            int n11;
            Point point3 = hint.getNeighborGrid();
            if (hint.isRotation() || point3.equals(point)) {
                if (hint.getValue() == Hint.Value.GOOD) {
                    ++n3;
                }
                if (hint.getValue() != Hint.Value.BAD) continue;
                ++n2;
                continue;
            }
            n = point3.x - point.x;
            int n12 = point3.y - point.y;
            int n13 = n < 0 ? -1 : (n = n > 0 ? 1 : 0);
            n12 = n12 < 0 ? -1 : (n12 > 0 ? 1 : 0);
            int n14 = 0;
            int n15 = 0;
            boolean bl3 = false;
            if (n == 0 || n12 == 0) {
                for (n11 = 0; n11 < n4 && !bl3; ++n11) {
                    for (n10 = 0; n10 <= n4 / 2 && !bl3; ++n10) {
                        for (n9 = -1; n9 <= 1 && !bl3; n9 += 2) {
                            if (n == 0 && n12 == -1) {
                                n14 = n4 / 2 + n9 * n10;
                                n15 = n11;
                            } else if (n == 0 && n12 == 1) {
                                n14 = n4 / 2 + n9 * n10;
                                n15 = n4 - n11 - 1;
                            } else if (n == -1 && n12 == 0) {
                                n14 = n11;
                                n15 = n4 / 2 + n9 * n10;
                            } else if (n == 1 && n12 == 0) {
                                n14 = n4 - n11 - 1;
                                n15 = n4 / 2 + n9 * n10;
                            }
                            if (n14 < 0 || n14 >= n4 || n15 < 0 || n15 >= n4 || blArray[n14][n15]) continue;
                            bl3 = true;
                            blArray[n14][n15] = true;
                        }
                    }
                }
            } else {
                for (n11 = 0; n11 < n4 * 2 - 1 && !bl3; ++n11) {
                    n10 = 1 + (n11 < n4 ? n11 : n4 * 2 - 2 - n11);
                    for (n9 = 0; n9 <= n10 / 2 && !bl3; ++n9) {
                        for (int i = 1; i >= -1 && !bl3; i -= 2) {
                            if (n == -1 && n12 == -1) {
                                n14 = n11 / 2;
                                n15 = (n11 + 1) / 2;
                                n14 += i * n9;
                                n15 -= i * n9;
                            } else if (n == 1 && n12 == -1) {
                                n14 = n4 - 1 - n11 / 2;
                                n15 = (n11 + 1) / 2;
                                n14 -= i * n9;
                                n15 -= i * n9;
                            } else if (n == -1 && n12 == 1) {
                                n14 = n11 / 2;
                                n15 = n4 - 1 - (n11 + 1) / 2;
                                n14 += i * n9;
                                n15 += i * n9;
                            } else {
                                n14 = n4 - 1 - n11 / 2;
                                n15 = n4 - 1 - (n11 + 1) / 2;
                                n14 -= i * n9;
                                n15 += i * n9;
                            }
                            if (n14 < 0 || n14 >= n4 || n15 < 0 || n15 >= n4 || blArray[n14][n15]) continue;
                            bl3 = true;
                            blArray[n14][n15] = true;
                        }
                    }
                }
            }
            if (!bl3) continue;
            ++n;
            ++n12;
            if (hint.getValue() == Hint.Value.GOOD) {
                graphics2D.drawImage(Rule.GOOD_ARROWS[n12][n].get(), n14 * 9, n15 * 9, 9, 9, this);
            }
            if (hint.getValue() != Hint.Value.BAD) continue;
            graphics2D.drawImage(Rule.BAD_ARROWS[n12][n].get(), n14 * 9, n15 * 9, 9, 9, this);
        }
        int n16 = Math.min(n3, n2);
        n3 -= n16;
        n2 -= n16;
        while (n16 > 0 || n3 > 0 || n2 > 0) {
            int n17 = 0;
            int n18 = 0;
            n = 0;
            for (n18 = 0; n18 < n4; ++n18) {
                for (n17 = 0; n17 < n4; ++n17) {
                    if (blArray[n17][n18]) continue;
                    blArray[n17][n18] = true;
                    n = 1;
                    break;
                }
                if (n != 0) break;
            }
            if (n == 0) break;
            if (n16 > 0) {
                graphics2D.drawImage(Rule.EQUAL.get(), n17 * 9, n18 * 9, 9, 9, this);
                --n16;
                continue;
            }
            if (n3 > 0) {
                graphics2D.drawImage(Rule.GOOD.get(), n17 * 9, n18 * 9, 9, 9, this);
                --n3;
                continue;
            }
            if (n2 <= 0) continue;
            graphics2D.drawImage(Rule.BAD.get(), n17 * 9, n18 * 9, 9, 9, this);
            --n2;
        }
        graphics2D.translate(-point2.x, -point2.y);
    }

    void DrawSquareWithPath(Point point, Graphics graphics) {
        if (this.image == null) {
            return;
        }
        java.awt.Image image = PlantList.getResources().getPlant(116).getImage().get();
        Point point2 = new Point(point);
        graphics.drawImage(image, 0, 0, 66, 66, 0, 0, 48, 48, this);
        for (int i = 0; i < 4; ++i) {
            switch (i) {
                case 0: {
                    point2.translate(0, -1);
                    break;
                }
                case 1: {
                    point2.translate(1, 1);
                    break;
                }
                case 2: {
                    point2.translate(-1, 1);
                    break;
                }
                case 3: {
                    point2.translate(-1, -1);
                }
            }
            List<Plant> list = this.garden.getPlants(this.year, point2);
            if (list == null || !list.contains(PlantList.getResources().getPlant(116))) {
                graphics.drawImage(image, 0, 0, 66, 66, 0, 240 + i * 48, 48, 288 + i * 48, this);
                continue;
            }
            graphics.drawImage(image, 0, 0, 66, 66, 0, 48 + i * 48, 48, 96 + i * 48, this);
        }
    }

    protected void drawGrid(Graphics graphics) {
        int n;
        graphics.setColor(new Color(0, 0, 0, 25));
        int n2 = 0;
        while ((n = n2 * 66 * this.getZoomFactor() / 100) < this.getWidth()) {
            graphics.drawLine(n, 0, n, this.getHeight());
            ++n2;
        }
        n2 = 0;
        while ((n = n2 * 66 * this.getZoomFactor() / 100) < this.getHeight()) {
            graphics.drawLine(0, n, this.getWidth(), n);
            ++n2;
        }
    }

    protected void printGrid(Graphics graphics, Point point, Point point2) {
        int n;
        int n2;
        graphics.setColor(new Color(0, 0, 0, 25));
        for (n2 = 0; n2 <= point2.x - point.x; ++n2) {
            n = n2 * this.getZoomFactor() * 36 / 100;
            graphics.drawLine(n, 0, n, (point2.y - point.y) * this.getZoomFactor() * 36 / 100);
        }
        for (n2 = 0; n2 <= point2.y - point.y; ++n2) {
            n = n2 * this.getZoomFactor() * 36 / 100;
            graphics.drawLine(0, n, (point2.x - point.x) * this.getZoomFactor() * 36 / 100, n);
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        java.awt.Rectangle rectangle = graphics.getClipBounds();
        this.drawGrid(graphics);
        if (this.background == null) {
            this.createBackgroundImage();
        }
        if (this.image == null) {
            this.createImage();
        }
        graphics.drawImage(this.background, rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height, rectangle.x * 100 / this.getZoomFactor(), rectangle.y * 100 / this.getZoomFactor(), (rectangle.x + rectangle.width) * 100 / this.getZoomFactor(), (rectangle.y + rectangle.height) * 100 / this.getZoomFactor(), this);
        graphics.drawImage(this.image, rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height, rectangle.x * 100 / this.getZoomFactor(), rectangle.y * 100 / this.getZoomFactor(), (rectangle.x + rectangle.width) * 100 / this.getZoomFactor(), (rectangle.y + rectangle.height) * 100 / this.getZoomFactor(), this);
        this.drawPreviewOutsideBounds((Graphics2D)graphics);
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        Point point = this.LocationToGrid(mouseEvent.getPoint());
        List<Plant> list = this.garden.getPlants(this.year, point);
        if (list == null || list.isEmpty()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        Translation translation = Translation.getPreferred();
        stringBuilder.append("<html><b>");
        boolean bl = true;
        for (Plant object2 : list) {
            if (!bl) {
                stringBuilder.append(",");
            }
            bl = false;
            stringBuilder.append(translation.translate(object2));
        }
        stringBuilder.append("</b>");
        stringBuilder.append("<br>");
        ArrayList arrayList = new ArrayList();
        HintList hintList = Rule.getHints(this.garden, this.year, point, true);
        if (hintList != null) {
            stringBuilder.append(hintList.getToolTipText());
        }
        return stringBuilder.toString();
    }

    public java.awt.Point GridToImageLocation(Point point) {
        Point point2 = this.garden.getBounds().getLocation();
        java.awt.Point point3 = new java.awt.Point(point.x, point.y);
        point3.translate(-point2.x + 1, -point2.y + 1);
        point3.x *= 66;
        point3.y *= 66;
        return point3;
    }

    public java.awt.Point GridToLocation(Point point) {
        Point point2 = this.garden.getBounds().getLocation();
        Dimension dimension = this.getImageSize();
        java.awt.Rectangle rectangle = this.getGardenBounds();
        rectangle.grow(1, 1);
        java.awt.Point point3 = new java.awt.Point(point.x, point.y);
        point3.translate(-point2.x + 1, -point2.y + 1);
        point3.x = point3.x * dimension.width * this.getZoomFactor() / 100 / rectangle.width;
        point3.y = point3.y * dimension.height * this.getZoomFactor() / 100 / rectangle.height;
        return point3;
    }

    public Point LocationToGrid(java.awt.Point point) {
        Point point2 = this.garden.getBounds().getLocation();
        Dimension dimension = this.getImageSize();
        java.awt.Rectangle rectangle = this.getGardenBounds();
        rectangle.grow(1, 1);
        Point point3 = new Point(point.x * rectangle.width * 100 / dimension.width / this.getZoomFactor(), point.y * rectangle.height * 100 / dimension.height / this.getZoomFactor());
        point3.translate(point2.x - 1, point2.y - 1);
        return point3;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        log.info("Print page " + Integer.toString(n));
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        int n2 = (int)pageFormat.getImageableWidth();
        int n3 = (int)pageFormat.getImageableHeight();
        Font font = new Font("SansSerif", 1, 20);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        graphics.drawString(Integer.toString(this.year), 0, fontMetrics.getAscent());
        n3 -= fontMetrics.getHeight();
        graphics2D.translate(0, fontMetrics.getHeight());
        font = new Font("SansSerif", 0, 10);
        fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        Dimension dimension = new Dimension((n2 -= fontMetrics.stringWidth("999")) * 100 / 36 / this.getZoomFactor(), (n3 -= fontMetrics.getHeight()) * 100 / 36 / this.getZoomFactor());
        Rectangle rectangle = this.garden.getBounds();
        Dimension dimension2 = new Dimension(rectangle.width / dimension.width + (rectangle.width % dimension.width == 0 ? 0 : 1), rectangle.height / dimension.height + (rectangle.height % dimension.height == 0 ? 0 : 1));
        if (n >= dimension2.width * dimension2.height) {
            return 1;
        }
        Point point = new Point(dimension.width * (n % dimension2.width), dimension.height * (n / dimension2.width));
        Point point2 = new Point(Math.min(rectangle.width, point.x + dimension.width), Math.min(rectangle.height, point.y + dimension.height));
        graphics2D.translate(0, fontMetrics.getHeight());
        GardenPanelHeaders.paintHeader(graphics, 36, this.getZoomFactor(), 1, 0, point.y, point2.y);
        graphics2D.translate(0, -fontMetrics.getHeight());
        graphics2D.translate(fontMetrics.stringWidth("999"), 0);
        GardenPanelHeaders.paintHeader(graphics, 36, this.getZoomFactor(), 0, 0, point.x, point2.x);
        graphics2D.translate(0, fontMetrics.getHeight());
        this.printGrid(graphics, point, point2);
        if (this.image == null) {
            this.createImage();
        }
        point.translate(rectangle.x, rectangle.y);
        point2.translate(rectangle.x, rectangle.y);
        java.awt.Point point3 = this.GridToImageLocation(point);
        java.awt.Point point4 = this.GridToImageLocation(point2);
        point4.translate(-1, -1);
        graphics.drawImage(this.image, 0, 0, (point2.x - point.x) * 36 * this.getZoomFactor() / 100 - 1, (point2.y - point.y) * 36 * this.getZoomFactor() / 100 - 1, point3.x, point3.y, point4.x, point4.y, this);
        return 0;
    }

    public int getNumberOfPages(PageFormat pageFormat) {
        Dimension dimension = new Dimension((int)((pageFormat.getImageableWidth() - 20.0) * 100.0 / 36.0 / (double)this.getZoomFactor()), (int)((pageFormat.getImageableHeight() - 36.0 - 20.0) * 100.0 / 36.0 / (double)this.getZoomFactor()));
        Rectangle rectangle = this.garden.getBounds();
        Dimension dimension2 = new Dimension(rectangle.width / dimension.width + (rectangle.width % dimension.width == 0 ? 0 : 1), rectangle.height / dimension.height + (rectangle.height % dimension.height == 0 ? 0 : 1));
        return dimension2.width * dimension2.height;
    }

    @Override
    public void yearDeleted() {
    }

    @Override
    public void hintsChanged(int n, Point point) {
        this.plantsChanged(n, point);
    }

    @Override
    public void plantsChanged(int n, Point point) {
        if (n != this.year) {
            return;
        }
        if (this.image == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)this.image.getGraphics();
        this.DrawSquare(point, this.garden.getPlants(n, point), graphics2D, true);
        java.awt.Point point2 = this.GridToLocation(new Point(point.x, point.y));
        this.repaint(point2.x, point2.y, 66 * this.getZoomFactor() / 100, 66 * this.getZoomFactor() / 100);
    }

    @Override
    public void boundsChanged(Rectangle rectangle) {
        this.background = null;
        this.image = null;
        this.setPreferredSize(this.getImageSize());
        this.revalidate();
        this.repaint();
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        boolean bl;
        JScrollBar jScrollBar = (JScrollBar)adjustmentEvent.getAdjustable();
        boolean bl2 = bl = jScrollBar.getValue() + jScrollBar.getVisibleAmount() == jScrollBar.getMaximum();
        if (jScrollBar == this.scrollPane.getHorizontalScrollBar()) {
            this.horizontalToEnd = bl;
        } else {
            this.verticalToEnd = bl;
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        JScrollBar jScrollBar;
        DefaultBoundedRangeModel defaultBoundedRangeModel = (DefaultBoundedRangeModel)changeEvent.getSource();
        JScrollBar jScrollBar2 = this.scrollPane.getVerticalScrollBar();
        JScrollBar jScrollBar3 = this.scrollPane.getHorizontalScrollBar();
        JScrollBar jScrollBar4 = jScrollBar = defaultBoundedRangeModel == jScrollBar2.getModel() ? jScrollBar2 : jScrollBar3;
        if (defaultBoundedRangeModel == jScrollBar2.getModel()) {
            if (this.verticalLastMax == defaultBoundedRangeModel.getMaximum()) {
                return;
            }
            this.verticalLastMax = defaultBoundedRangeModel.getMaximum();
        } else {
            if (this.horizontalLastMax == defaultBoundedRangeModel.getMaximum()) {
                return;
            }
            this.horizontalLastMax = defaultBoundedRangeModel.getMaximum();
        }
        if (this.horizontalToEnd && jScrollBar == jScrollBar3 || this.verticalToEnd && jScrollBar == jScrollBar2) {
            jScrollBar.setValue(jScrollBar.getMaximum() - jScrollBar.getVisibleAmount());
        }
    }

    static {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        cursorDelete = toolkit.createCustomCursor(Image.getFromResources("delete_cursor.png").get(), new java.awt.Point(16, 14), "delete");
        cursorPick = toolkit.createCustomCursor(Image.getFromResources("picker_cursor.png").get(), new java.awt.Point(0, 31), "pick");
    }
}

