/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.kga.gui.desktop;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.sourceforge.kga.Garden;
import org.sourceforge.kga.Plant;
import org.sourceforge.kga.PlantComparatorByName;
import org.sourceforge.kga.PlantList;
import org.sourceforge.kga.TagList;
import org.sourceforge.kga.TagListener;
import org.sourceforge.kga.Taxon;
import org.sourceforge.kga.gui.desktop.PlantComponent;
import org.sourceforge.kga.gui.desktop.PlantListPanelListener;
import org.sourceforge.kga.gui.desktop.TagItem;
import org.sourceforge.kga.plant.NotTagged;
import org.sourceforge.kga.plant.Tag;
import org.sourceforge.kga.plant.TagInGarden;
import org.sourceforge.kga.plant.TagInInventory;
import org.sourceforge.kga.translation.Iso639_1;
import org.sourceforge.kga.translation.Translation;

public class SpeciesListPanel
extends JPanel
implements TagListener {
    private static Logger log = Logger.getLogger(Garden.class.getName());
    GroupLayout layout;
    JPanel panelFilter = new JPanel();
    JScrollPane scrollSpecies = new JScrollPane(20, 31);
    JLabel labelFamily = new JLabel(Translation.getPreferred().family());
    JComboBox<FamilyComboItem> comboFamily = new JComboBox();
    JLabel labelName = new JLabel(Translation.getPreferred().name());
    JTextField textName = new JTextField();
    JLabel labelTag = new JLabel(Translation.getPreferred().tag());
    JComboBox<TagItem> comboTag = new JComboBox();
    JPanel panelSpecies = null;
    List<PlantComponent> components = null;
    ArrayList<PlantListPanelListener> listeners = new ArrayList();
    private boolean multipleSelection = false;
    ArrayList<PlantComponent> selectedSpecies = new ArrayList();

    public boolean getMultipleSelection() {
        return this.multipleSelection;
    }

    public void setMultipleSelection(boolean bl) {
        this.multipleSelection = bl;
    }

    @Override
    public void tagAdded(Tag tag) {
        this.loadTags();
    }

    @Override
    public void tagDeleted(Tag tag) {
        this.loadTags();
    }

    @Override
    public void tagChanged(Tag tag) {
        TagItem tagItem = (TagItem)this.comboTag.getSelectedItem();
        if (tagItem.tag == tag) {
            this.filterSpecies();
        }
    }

    public SpeciesListPanel() {
        super(new BorderLayout());
        this.layout = new GroupLayout(this.panelFilter);
        this.layout.setAutoCreateGaps(true);
        this.layout.setAutoCreateContainerGaps(true);
        this.panelFilter.setLayout(this.layout);
        this.layout.setHorizontalGroup(this.layout.createSequentialGroup().addGroup(this.layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelFamily).addComponent(this.labelName).addComponent(this.labelTag)).addGroup(this.layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.comboFamily).addComponent(this.textName).addComponent(this.comboTag)));
        this.layout.setVerticalGroup(this.layout.createSequentialGroup().addGroup(this.layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.labelFamily).addComponent(this.comboFamily)).addGroup(this.layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.labelName).addComponent(this.textName)).addGroup(this.layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.labelTag).addComponent(this.comboTag)));
        ArrayList<Plant> arrayList = new ArrayList<Plant>();
        ArrayList<Plant> arrayList2 = new ArrayList<Plant>();
        for (Plant plant : PlantList.getResources().getPlants()) {
            if (plant.getType() == Taxon.Type.FAMILY) {
                arrayList.add(plant);
                continue;
            }
            if (plant.getImage() == null) continue;
            arrayList2.add(plant);
        }
        Collections.sort(arrayList, new PlantComparatorByName());
        Collections.sort(arrayList2, new PlantComparatorByName());
        this.comboFamily.addItem(new FamilyComboItem(null));
        for (Plant plant : arrayList) {
            this.comboFamily.addItem(new FamilyComboItem(plant));
        }
        this.loadTags();
        this.scrollSpecies.getVerticalScrollBar().setUnitIncrement(16);
        this.components = new ArrayList<PlantComponent>();
        for (Plant plant : arrayList2) {
            PlantComponent plantComponent = new PlantComponent(plant);
            plantComponent.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (SpeciesListPanel.this.selectedSpecies.contains(mouseEvent.getComponent())) {
                        SpeciesListPanel.this.selectSpeciesComponent((PlantComponent)mouseEvent.getComponent(), false);
                    } else {
                        SpeciesListPanel.this.selectSpeciesComponent((PlantComponent)mouseEvent.getComponent(), true);
                    }
                }
            });
            this.components.add(plantComponent);
        }
        this.filterSpecies();
        this.add((Component)this.panelFilter, "First");
        this.add((Component)this.scrollSpecies, "Center");
        this.comboFamily.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SpeciesListPanel.this.filterSpecies();
            }
        });
        this.comboTag.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SpeciesListPanel.this.filterSpecies();
            }
        });
        this.textName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                SpeciesListPanel.this.filterSpecies();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                SpeciesListPanel.this.filterSpecies();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                SpeciesListPanel.this.filterSpecies();
            }
        });
        TagList.getInstance().addListener(this);
    }

    private void loadTags() {
        ArrayList<Tag> arrayList = new ArrayList<Tag>(TagList.getInstance().getTags());
        Collections.sort(arrayList, new Comparator<Tag>(){

            @Override
            public int compare(Tag tag, Tag tag2) {
                Translation translation = Translation.getPreferred();
                return translation.getCollator().compare(tag.getName(), tag2.getName());
            }
        });
        arrayList.add(0, NotTagged.getInstance());
        arrayList.add(0, TagInGarden.getInstance());
        arrayList.add(0, TagInInventory.getInstance());
        TagItem tagItem = (TagItem)this.comboTag.getSelectedItem();
        this.comboTag.removeAllItems();
        this.comboTag.addItem(new TagItem(null));
        for (Tag tag : arrayList) {
            TagItem tagItem2 = new TagItem(tag);
            this.comboTag.addItem(tagItem2);
            if (tagItem == null || tag != tagItem.tag) continue;
            this.comboTag.setSelectedItem(tagItem2);
        }
        if (this.comboTag.getSelectedItem() == null) {
            this.comboTag.setSelectedIndex(0);
        }
    }

    public void addListener(PlantListPanelListener plantListPanelListener) {
        this.listeners.add(plantListPanelListener);
    }

    public void removeListener(PlantListPanelListener plantListPanelListener) {
        this.listeners.remove(plantListPanelListener);
    }

    private void selectSpeciesComponent(PlantComponent plantComponent, boolean bl) {
        if (bl && this.selectedSpecies.contains(plantComponent) || !bl && !this.selectedSpecies.contains(plantComponent)) {
            return;
        }
        log.info("selectedSpeciesComponent " + plantComponent.plant.getName() + " " + Boolean.toString(bl));
        if (!this.multipleSelection && this.selectedSpecies.size() > 0) {
            for (PlantComponent object : this.selectedSpecies) {
                object.setSelected(false);
            }
            this.selectedSpecies.clear();
            if (!bl) {
                for (PlantListPanelListener plantListPanelListener : this.listeners) {
                    plantListPanelListener.selectedPlantChanged(null);
                }
            }
        }
        if (bl) {
            plantComponent.setSelected(true);
            this.selectedSpecies.add(plantComponent);
            if (!this.multipleSelection) {
                for (PlantListPanelListener plantListPanelListener : this.listeners) {
                    plantListPanelListener.selectedPlantChanged(plantComponent.plant);
                }
            }
        } else if (this.multipleSelection) {
            plantComponent.setSelected(false);
            this.selectedSpecies.remove(plantComponent);
        }
    }

    private void filterSpecies() {
        log.info("filterSpecies");
        this.panelSpecies = new JPanel(new GridLayout(0, 1));
        for (PlantComponent plantComponent : this.components) {
            Plant plant = this.getSelectedFamily();
            if (plant != null && plant != plantComponent.plant.getFamily() || this.textName.getText().length() != 0 && !Iso639_1.containsText(plantComponent.plant.getName(), this.textName.getText()) && !Iso639_1.containsText(Translation.getPreferred().translate(plantComponent.plant), this.textName.getText())) continue;
            Tag tag = null;
            if (this.comboTag.getSelectedItem() != null) {
                tag = ((TagItem)this.comboTag.getSelectedItem()).tag;
            }
            if (tag != null && !tag.getSpecies().contains(plantComponent.plant)) continue;
            this.panelSpecies.add(plantComponent);
        }
        if (this.panelSpecies.getComponentCount() == 1) {
            this.selectSpeciesComponent((PlantComponent)this.panelSpecies.getComponent(0), true);
        }
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        jPanel.add((Component)this.panelSpecies, "North");
        this.scrollSpecies.setViewportView(jPanel);
    }

    public ArrayList<Plant> getSelectedSpecies() {
        ArrayList<Plant> arrayList = new ArrayList<Plant>();
        for (PlantComponent plantComponent : this.selectedSpecies) {
            arrayList.add(plantComponent.plant);
        }
        return arrayList;
    }

    public void setSelectedSpecies(Plant plant) {
        for (PlantComponent plantComponent : this.components) {
            if (plantComponent.plant != plant) continue;
            this.selectSpeciesComponent(plantComponent, true);
            return;
        }
    }

    public Plant getSelectedFamily() {
        return ((FamilyComboItem)this.comboFamily.getSelectedItem()).family;
    }

    public void setSelectedFamily(Plant plant) {
        int n = this.comboFamily.getItemCount();
        for (int i = 0; i < n; ++i) {
            FamilyComboItem familyComboItem = this.comboFamily.getItemAt(i);
            if (familyComboItem.family != plant) continue;
            this.comboFamily.setSelectedIndex(i);
            return;
        }
    }

    public Tag getSelectedTag() {
        return ((TagItem)this.comboTag.getSelectedItem()).tag;
    }

    public void setSelectedTag(Tag tag) {
        int n = this.comboTag.getItemCount();
        for (int i = 0; i < n; ++i) {
            TagItem tagItem = this.comboTag.getItemAt(i);
            if (tagItem.tag != tag) continue;
            this.comboTag.setSelectedIndex(i);
            return;
        }
    }

    public void selectAll() {
        for (Component component : this.panelSpecies.getComponents()) {
            this.selectSpeciesComponent((PlantComponent)component, true);
        }
    }

    public void unselectAll() {
        for (Component component : this.panelSpecies.getComponents()) {
            this.selectSpeciesComponent((PlantComponent)component, false);
        }
    }

    public void invertSelection() {
        for (Component component : this.panelSpecies.getComponents()) {
            PlantComponent plantComponent;
            this.selectSpeciesComponent(plantComponent, !this.selectedSpecies.contains(plantComponent = (PlantComponent)component));
        }
    }

    private class FamilyComboItem {
        Plant family;

        public FamilyComboItem(Plant plant) {
            this.family = plant;
        }

        public String toString() {
            if (this.family == null) {
                return "";
            }
            return Translation.getPreferred().translate(this.family);
        }
    }
}

