/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.kga.gui.desktop.actions;

import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Locale;
import java.util.logging.Logger;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.sourceforge.kga.Garden;
import org.sourceforge.kga.gui.desktop.Gui;
import org.sourceforge.kga.gui.desktop.actions.KgaAction;
import org.sourceforge.kga.translation.Iso639_1;
import org.sourceforge.kga.translation.Translation;

public class Language
extends KgaAction {
    private static Logger log = Logger.getLogger(Garden.class.getName());
    private static final long serialVersionUID = 1L;
    JPanel panel;
    JComboBox<Iso639_1.Language> combo;
    JLabel labelAuthor;

    public Language(Gui gui) {
        super(gui, Translation.getPreferred().action_language());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        void var5_11;
        void var5_9;
        String string;
        Serializable serializable;
        if (Translation.getPreferred() == null) {
            serializable = Locale.getDefault();
            string = serializable.getLanguage();
        } else {
            string = Translation.getPreferred().getLanguage();
        }
        this.panel = new JPanel();
        serializable = new GridLayout(2, 1);
        this.panel.setLayout((LayoutManager)((Object)serializable));
        this.labelAuthor = new JLabel();
        this.combo = new JComboBox();
        this.combo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Iso639_1.Language language = (Iso639_1.Language)Language.this.combo.getSelectedItem();
                Translation translation = Translation.getTranslation(language.code);
                if (translation != null) {
                    Language.this.labelAuthor.setText(translation.getAuthor());
                }
            }
        });
        for (Iso639_1.Language object2 : Translation.getLanguageItems()) {
            this.combo.addItem(object2);
            if (!object2.code.equals(string)) continue;
            this.combo.setSelectedItem(object2);
        }
        this.panel.add(this.combo);
        this.panel.add(this.labelAuthor);
        int n = JOptionPane.showConfirmDialog(this.getGui(), this.panel, Translation.getPreferred().action_language(), 2, -1);
        Object var5_7 = null;
        if (n == 0) {
            String string2 = ((Iso639_1.Language)this.combo.getSelectedItem()).code;
            log.info("Selected language=" + string2);
        }
        if (actionEvent == null && var5_9 == null) {
            log.info("Select the default language ( english )");
            String string3 = "en";
        }
        if (var5_11 == null || var5_11.equals(Translation.getPreferred().getLanguage())) {
            return;
        }
        Translation.setCurrentLanguage((String)var5_11);
        if (actionEvent != null) {
            this.getGui().resetGui();
        }
    }
}

