/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.kga.io;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.sourceforge.kga.Garden;
import org.sourceforge.kga.Plant;
import org.sourceforge.kga.PlantList;
import org.sourceforge.kga.Point;
import org.sourceforge.kga.io.GardenFormat;
import org.sourceforge.kga.io.InvalidFormatException;
import org.sourceforge.kga.wrappers.XmlException;
import org.sourceforge.kga.wrappers.XmlReader;
import org.sourceforge.kga.wrappers.XmlWriter;

class GardenFormatXmlV1
implements GardenFormat {
    private static Logger log = Logger.getLogger(Garden.class.getName());
    private static final int KGA_FILE_VERSION = 1;
    public static final String namespace = "org:sourceforge:kga:garden";

    GardenFormatXmlV1() {
    }

    @Override
    public void load(Garden garden, InputStream inputStream) throws IOException, InvalidFormatException {
        try {
            int n;
            XmlReader xmlReader = new XmlReader(inputStream);
            while (xmlReader.hasNext() && xmlReader.next() != 1) {
            }
            if (xmlReader.getLocalName().compareTo("garden") != 0) {
                throw new InvalidFormatException();
            }
            String string = xmlReader.getAttributeValue("", "version");
            if (Integer.parseInt(string) != 1) {
                throw new InvalidFormatException();
            }
            while (xmlReader.hasNext() && (n = xmlReader.next()) != 8) {
                if (n != 1) continue;
                int n2 = Integer.parseInt(xmlReader.getAttributeValue("", "year"));
                int n3 = Integer.parseInt(xmlReader.getAttributeValue("", "x"));
                int n4 = Integer.parseInt(xmlReader.getAttributeValue("", "y"));
                Point point = new Point(n3, n4);
                String string2 = xmlReader.getAttributeValue("", "species");
                if (string2.length() == 0) continue;
                for (String string3 : string2.split(";")) {
                    int n5 = Integer.parseInt(string3);
                    if (n5 == 117 || n5 == 119) {
                        n5 = 116;
                    }
                    garden.addPlant(n2, point, PlantList.getResources().getPlant(n5));
                }
            }
        }
        catch (XmlException xmlException) {
            throw new IOException(xmlException);
        }
        log.info("Garden loaded");
    }

    @Override
    public void save(Garden garden, DataOutputStream dataOutputStream) throws IOException {
        try {
            XmlWriter xmlWriter = new XmlWriter(dataOutputStream, "UTF-8", "1.0");
            xmlWriter.writeCharacters("\n");
            xmlWriter.writeStartElement("garden");
            xmlWriter.setDefaultNamespace(namespace);
            xmlWriter.writeDefaultNamespace(namespace);
            xmlWriter.writeAttribute("version", Integer.toString(1));
            for (Map.Entry<Integer, HashMap<Point, List<Plant>>> entry : garden.getAllSquares().entrySet()) {
                for (Map.Entry<Point, List<Plant>> entry2 : entry.getValue().entrySet()) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (Plant plant : entry2.getValue()) {
                        if (stringBuilder.length() != 0) {
                            stringBuilder.append(";");
                        }
                        stringBuilder.append(plant.getId());
                    }
                    if (stringBuilder.length() == 0) continue;
                    xmlWriter.writeCharacters("\n    ");
                    xmlWriter.writeEmptyElement("square");
                    xmlWriter.writeAttribute("year", Integer.toString(entry.getKey()));
                    xmlWriter.writeAttribute("x", Integer.toString(entry2.getKey().x));
                    xmlWriter.writeAttribute("y", Integer.toString(entry2.getKey().y));
                    xmlWriter.writeAttribute("species", stringBuilder.toString());
                }
            }
            xmlWriter.writeCharacters("\n");
            xmlWriter.writeEndElement();
            xmlWriter.flush();
            xmlWriter.close();
        }
        catch (XmlException xmlException) {
            throw new IOException(xmlException);
        }
    }
}

