/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.kga.io;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.logging.Logger;
import org.sourceforge.kga.Garden;
import org.sourceforge.kga.PlantList;
import org.sourceforge.kga.SeedList;
import org.sourceforge.kga.io.InvalidFormatException;
import org.sourceforge.kga.io.SeedListFormat;
import org.sourceforge.kga.wrappers.XmlException;
import org.sourceforge.kga.wrappers.XmlReader;
import org.sourceforge.kga.wrappers.XmlWriter;

public class SeedListFormatV1
implements SeedListFormat {
    private static Logger log = Logger.getLogger(Garden.class.getName());
    private static final int SEED_FILE_VERSION = 1;
    public static final String namespace = "org:sourceforge:kga:seedList";

    @Override
    public void load(SeedList seedList, SeedList seedList2, InputStream inputStream) throws IOException, InvalidFormatException {
        try {
            int n;
            XmlReader xmlReader = new XmlReader(inputStream);
            while (xmlReader.hasNext() && xmlReader.next() != 1) {
            }
            if (xmlReader.getLocalName().compareTo("seed-list") != 0) {
                throw new InvalidFormatException();
            }
            String string = xmlReader.getAttributeValue("", "version");
            if (Integer.parseInt(string) != 1) {
                throw new InvalidFormatException();
            }
            SeedList seedList3 = null;
            boolean bl = false;
            while (xmlReader.hasNext() && (n = xmlReader.next()) != 8) {
                String[] stringArray;
                SeedList.Entry.PlantOrUnregistered plantOrUnregistered;
                if (n == 2) {
                    if (!bl) {
                        seedList3 = null;
                    }
                    bl = false;
                    continue;
                }
                if (n != 1) continue;
                if (seedList3 == null) {
                    if (xmlReader.getLocalName().equals("inventory")) {
                        seedList3 = seedList;
                        continue;
                    }
                    if (!xmlReader.getLocalName().equals("shopping")) continue;
                    seedList3 = seedList2;
                    continue;
                }
                bl = true;
                String string2 = xmlReader.getAttributeValue("", "plant");
                if (string2 == null) {
                    int n2 = Integer.parseInt(xmlReader.getAttributeValue("", "plantId"));
                    plantOrUnregistered = new SeedList.Entry.PlantOrUnregistered(PlantList.getResources().getPlant(n2));
                } else {
                    plantOrUnregistered = new SeedList.Entry.PlantOrUnregistered(string2);
                }
                String string3 = xmlReader.getAttributeValue("", "variety");
                String string4 = xmlReader.getAttributeValue("", "quantity");
                SeedList.Entry.Quantity quantity = null;
                if (string4 != null) {
                    quantity = new SeedList.Entry.Quantity();
                    stringArray = string4.split(" ");
                    if (stringArray.length > 0) {
                        quantity.quantity = Double.parseDouble(stringArray[0]);
                    }
                    quantity.unit = stringArray.length > 1 ? stringArray[1] : "";
                }
                stringArray = xmlReader.getAttributeValue("", "comment");
                LocalDate localDate = LocalDate.parse(xmlReader.getAttributeValue("", "validFrom"), DateTimeFormatter.BASIC_ISO_DATE);
                LocalDate localDate2 = null;
                String string5 = xmlReader.getAttributeValue("", "validTo");
                if (string5 != null) {
                    localDate2 = LocalDate.parse(string5, DateTimeFormatter.BASIC_ISO_DATE);
                }
                seedList3.add(plantOrUnregistered, string3, quantity, (String)stringArray, localDate, localDate2);
            }
        }
        catch (XmlException xmlException) {
            throw new IOException(xmlException);
        }
        log.info("Garden loaded");
    }

    @Override
    public void save(SeedList seedList, SeedList seedList2, DataOutputStream dataOutputStream) throws IOException {
        try {
            XmlWriter xmlWriter = new XmlWriter(dataOutputStream, "UTF-8", "1.0");
            xmlWriter.writeCharacters("\n");
            xmlWriter.writeStartElement("seed-list");
            xmlWriter.setDefaultNamespace(namespace);
            xmlWriter.writeDefaultNamespace(namespace);
            xmlWriter.writeAttribute("version", Integer.toString(1));
            for (int i = 0; i < 2; ++i) {
                SeedList seedList3;
                xmlWriter.writeCharacters("\n    ");
                if (i == 0) {
                    xmlWriter.writeStartElement("inventory");
                    seedList3 = seedList;
                } else {
                    xmlWriter.writeStartElement("shopping");
                    seedList3 = seedList2;
                }
                for (SeedList.Entry entry : seedList3.getAllEntries()) {
                    xmlWriter.writeCharacters("\n        ");
                    xmlWriter.writeEmptyElement("seed");
                    if (entry.getPlant().plant == null) {
                        xmlWriter.writeAttribute("plant", entry.getPlant().unregisteredPlant);
                    } else {
                        xmlWriter.writeAttribute("plantId", Integer.toString(entry.getPlant().plant.getId()));
                    }
                    if (entry.getVariety() != null) {
                        xmlWriter.writeAttribute("variety", entry.getVariety());
                    }
                    if (entry.getQuantity() != null) {
                        xmlWriter.writeAttribute("quantity", Double.toString(entry.getQuantity().quantity) + " " + entry.getQuantity().unit);
                    }
                    if (entry.getComment() != null && !entry.getComment().isEmpty()) {
                        xmlWriter.writeAttribute("comment", entry.getComment());
                    }
                    xmlWriter.writeAttribute("validFrom", DateTimeFormatter.BASIC_ISO_DATE.format(entry.getValidFrom()));
                    if (entry.getValidTo() == null) continue;
                    xmlWriter.writeAttribute("validTo", DateTimeFormatter.BASIC_ISO_DATE.format(entry.getValidTo()));
                }
                xmlWriter.writeCharacters("\n    ");
                xmlWriter.writeEndElement();
            }
            xmlWriter.writeCharacters("\n");
            xmlWriter.writeEndElement();
            xmlWriter.flush();
            xmlWriter.close();
        }
        catch (XmlException xmlException) {
            throw new IOException(xmlException);
        }
    }
}

