/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.kga.plant;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.sourceforge.kga.Animal;
import org.sourceforge.kga.Plant;
import org.sourceforge.kga.Taxon;
import org.sourceforge.kga.plant.Companion;
import org.sourceforge.kga.plant.Reference;
import org.sourceforge.kga.plant.ReferenceList;

public class CompanionList {
    private static Logger log = Logger.getLogger(CompanionList.class.getName());
    ArrayList<Companion> companions = new ArrayList();
    ArrayList<Companion> inheritedCache = null;
    Plant plant = null;

    public CompanionList(Plant plant) {
        this.plant = plant;
    }

    private static Companion findCompanion(ArrayList<Companion> arrayList, Plant plant, Companion.Type type, TreeSet<Animal> treeSet, TreeSet<Companion.Improve> treeSet2) {
        for (Companion companion : arrayList) {
            if (companion.plant.getId() != plant.getId() || companion.type.compareTo(type) != 0 || !companion.animals.equals(treeSet) || !companion.improve.equals(treeSet2)) continue;
            return companion;
        }
        return null;
    }

    private static Companion add(ArrayList<Companion> arrayList, Plant plant, Companion.Type type, TreeSet<Animal> treeSet, TreeSet<Companion.Improve> treeSet2, Reference reference) {
        Companion companion = CompanionList.findCompanion(arrayList, plant, type, treeSet, treeSet2);
        if (companion != null) {
            companion.references.add(reference);
            return companion;
        }
        Companion companion2 = new Companion();
        companion2.plant = plant;
        companion2.type = type;
        companion2.animals = treeSet;
        companion2.improve = treeSet2;
        companion2.references.add(reference);
        arrayList.add(companion2);
        return companion2;
    }

    public Companion add(Plant plant, Companion.Type type, TreeSet<Animal> treeSet, TreeSet<Companion.Improve> treeSet2, Reference reference) {
        this.cleanUpInheritedCache();
        return CompanionList.add(this.companions, plant, type, treeSet, treeSet2, reference);
    }

    private static Companion add(ArrayList<Companion> arrayList, Plant plant, Companion.Type type, TreeSet<Animal> treeSet, TreeSet<Companion.Improve> treeSet2, ReferenceList referenceList) {
        Companion companion = CompanionList.add(arrayList, plant, type, treeSet, treeSet2, (Reference)null);
        for (Reference reference : referenceList) {
            companion.references.add(reference);
        }
        return companion;
    }

    public Companion add(Plant plant, Companion.Type type, TreeSet<Animal> treeSet, TreeSet<Companion.Improve> treeSet2, ReferenceList referenceList) {
        this.cleanUpInheritedCache();
        return CompanionList.add(this.companions, plant, type, treeSet, treeSet2, referenceList);
    }

    private void cleanUpInheritedCache() {
        this.inheritedCache = null;
        for (Taxon taxon : this.plant.getChildren()) {
            ((Plant)taxon).getCompanions().cleanUpInheritedCache();
        }
    }

    public boolean isDefined() {
        return this.companions.size() != 0;
    }

    public Iterable<Companion> get() {
        return this.companions;
    }

    public Iterable<Companion> getInherited() {
        if (this.inheritedCache != null) {
            return this.inheritedCache;
        }
        this.inheritedCache = new ArrayList();
        for (Plant plant = this.plant; plant != null; plant = plant.getParent()) {
            for (Companion companion : plant.getCompanions().get()) {
                CompanionList.add(this.inheritedCache, companion.plant, companion.type, companion.animals, companion.improve, companion.references);
            }
        }
        Collections.sort(this.inheritedCache, new CompanionComparatorByParent());
        return this.inheritedCache;
    }

    public void logConflicts(Companion companion, StringBuilder stringBuilder) {
        for (Companion companion2 : this.companions) {
            if (companion2 == companion || companion.type.isBeneficial() == companion2.type.isBeneficial() || companion2.plant != companion.plant && !companion2.plant.isParentOf(companion.plant)) continue;
            stringBuilder.append("Conflict found: ");
            stringBuilder.append(this.plant.getName());
            stringBuilder.append(" (");
            stringBuilder.append(this.plant.getId());
            stringBuilder.append("): ");
            stringBuilder.append(companion.plant.getName());
            stringBuilder.append(" (");
            stringBuilder.append(companion.plant.getId());
            stringBuilder.append(") / ");
            stringBuilder.append(companion2.plant.getName());
            stringBuilder.append(" (");
            stringBuilder.append(companion2.plant.getId());
            stringBuilder.append(")\n");
        }
    }

    public void logConflicts(StringBuilder stringBuilder) {
        for (Companion companion : this.companions) {
            this.logConflicts(companion, stringBuilder);
        }
    }

    private class CompanionComparatorByParent
    implements Comparator<Companion> {
        private CompanionComparatorByParent() {
        }

        @Override
        public int compare(Companion companion, Companion companion2) {
            if (companion.plant.getType() != companion2.plant.getType()) {
                return companion2.plant.getType().ordinal() - companion.plant.getType().ordinal();
            }
            return companion.plant.getId() - companion2.plant.getId();
        }
    }
}

