/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.kga.rules;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.sourceforge.kga.Garden;
import org.sourceforge.kga.Plant;
import org.sourceforge.kga.Point;
import org.sourceforge.kga.plant.Companion;
import org.sourceforge.kga.plant.PropertySource;
import org.sourceforge.kga.plant.Reference;
import org.sourceforge.kga.plant.ReferenceList;
import org.sourceforge.kga.plant.SourceList;
import org.sourceforge.kga.rules.Hint;
import org.sourceforge.kga.rules.RotationRepetition;
import org.sourceforge.kga.rules.Rule;
import org.sourceforge.kga.translation.Translation;

public class HintList
implements Iterable<Hint> {
    private static Logger log = Logger.getLogger(Garden.class.getName());
    ArrayList<Hint> hints = new ArrayList();
    private Garden garden;
    private int year;
    private Point grid;
    private boolean detailed;
    int[] values = new int[Hint.Value.values().length];
    ArrayList<Hint> companionHints = new ArrayList();
    ArrayList<Hint> rotationHints = new ArrayList();

    public HintList(Garden garden, int n, Point point, boolean bl) {
        this.garden = garden;
        this.year = n;
        this.grid = point;
        this.detailed = bl;
    }

    public Garden getGarden() {
        return this.garden;
    }

    public int getYear() {
        return this.year;
    }

    public Point getGrid() {
        return this.grid;
    }

    public int getValue(Hint.Value value) {
        return this.values[value.ordinal()];
    }

    public boolean addRotationHint(Hint.Value value, Plant plant, Plant plant2, int n, Rule rule) {
        for (Hint hint : this.rotationHints) {
            if (hint.getValue() != value || hint.getCurrentPlant() != plant || hint.getNeighborPlant() != plant2 || hint.getNeighborYear() != n) continue;
            if (hint.getRule().getClass() == RotationRepetition.class) {
                return false;
            }
            if (this.detailed) {
                hint.addDetail(new Hint(plant, plant2, n, rule, value));
            }
            return true;
        }
        int n2 = value.ordinal();
        this.values[n2] = this.values[n2] + 1;
        Hint hint = new Hint(plant, plant2, n, rule, value);
        this.rotationHints.add(hint);
        this.hints.add(hint);
        return true;
    }

    private boolean duplicatedCompanion(Hint hint, Companion companion) {
        return hint.getCompanion().type == companion.type && hint.getCompanion().animals.equals(companion.animals) && hint.getCompanion().improve.equals(companion.improve);
    }

    public boolean addCompanionHint(Companion companion, Plant plant, Plant plant2, Point point, Rule rule) {
        Hint.Value value = companion.type.isBeneficial() ? Hint.Value.GOOD : Hint.Value.BAD;
        for (Hint hint : this.companionHints) {
            if (companion.plant.isParentOf(hint.getNeighborPlant()) && hint.getNeighborPlant() != plant2) {
                return true;
            }
            if (hint.getNeighborPlant() == plant2 && !hint.getNeighborGrid().equals(point)) {
                return true;
            }
            if (hint.getValue() != value || hint.getCurrentPlant() != plant || hint.getNeighborPlant() != plant2 || !hint.getNeighborGrid().equals(point)) continue;
            if (this.duplicatedCompanion(hint, companion)) {
                return true;
            }
            for (Hint hint2 : hint.getDetails()) {
                if (!this.duplicatedCompanion(hint2, companion)) continue;
                return true;
            }
            if (this.detailed) {
                hint.addDetail(new Hint(plant, plant2, point, rule, companion));
            }
            return true;
        }
        int n = value.ordinal();
        this.values[n] = this.values[n] + 1;
        Hint hint = new Hint(plant, plant2, point, rule, companion);
        this.companionHints.add(hint);
        this.hints.add(hint);
        return true;
    }

    @Override
    public Iterator<Hint> iterator() {
        return this.hints.iterator();
    }

    public boolean isEmpty() {
        return this.hints.isEmpty();
    }

    private void addHintDescription(StringBuilder stringBuilder, String string) {
        if (string.isEmpty()) {
            return;
        }
        stringBuilder.append("<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        stringBuilder.append(string);
    }

    private void addHintReferences(List<PropertySource> list, TreeSet<Integer> treeSet, ReferenceList referenceList) {
        for (Reference reference : referenceList) {
            treeSet.add(SourceList.add(list, reference.source));
        }
    }

    public String getToolTipText() {
        Translation translation = Translation.getPreferred();
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<PropertySource> arrayList = new ArrayList<PropertySource>();
        for (Hint object : this.hints) {
            if (object.getValue() == Hint.Value.TIP) continue;
            stringBuilder.append("<span style='color: ");
            stringBuilder.append(object.getValue() == Hint.Value.GOOD ? "green" : "red");
            stringBuilder.append("'>");
            if (object.isRotation()) {
                stringBuilder.append(translation.translate(object.getCurrentPlant()));
                if (object.getCurrentPlant() != object.getNeighborPlant()) {
                    stringBuilder.append(" ").append(translation.rotation_after()).append(" ").append(translation.translate(object.getNeighborPlant()));
                }
            } else {
                stringBuilder.append(translation.translate(object.getCurrentPlant())).append(" ");
                stringBuilder.append(object.getCompanion().type.isBeneficial() ? translation.companion_helped_by() : translation.companion_dislike());
                stringBuilder.append(" ").append(translation.translate(object.getNeighborPlant()));
            }
            int n = stringBuilder.length();
            this.addHintDescription(stringBuilder, object.getDescription());
            TreeSet<Integer> treeSet = new TreeSet<Integer>();
            this.addHintReferences(arrayList, treeSet, object.getReferences());
            for (Hint hint : object.getDetails()) {
                this.addHintDescription(stringBuilder, hint.getDescription());
                this.addHintReferences(arrayList, treeSet, hint.getReferences());
            }
            stringBuilder.append("</span><br/>");
            StringBuilder stringBuilder2 = new StringBuilder();
            for (Integer n2 : treeSet) {
                if (stringBuilder2.length() != 0) {
                    stringBuilder2.append(",");
                }
                stringBuilder2.append(" [");
                stringBuilder2.append(n2 + 1);
                stringBuilder2.append("]");
            }
            stringBuilder.insert(n, stringBuilder2);
        }
        if (!arrayList.isEmpty()) {
            stringBuilder.append("<hr>");
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            PropertySource propertySource = (PropertySource)arrayList.get(i);
            stringBuilder.append("[");
            stringBuilder.append(i + 1);
            stringBuilder.append("] ");
            stringBuilder.append(propertySource.name);
            if (propertySource.url != null && !propertySource.url.isEmpty()) {
                stringBuilder.append("<br/>&nbsp;&nbsp;&nbsp;&nbsp;<i>");
                if (propertySource.url.length() > 50) {
                    stringBuilder.append(propertySource.url.substring(0, 50));
                    stringBuilder.append("...");
                } else {
                    stringBuilder.append(propertySource.url);
                }
                stringBuilder.append("</i>");
            }
            stringBuilder.append("<br/>");
        }
        return stringBuilder.toString();
    }
}

