/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.kga.rules;

import java.util.List;
import java.util.logging.Logger;
import org.sourceforge.kga.Garden;
import org.sourceforge.kga.Plant;
import org.sourceforge.kga.Point;
import org.sourceforge.kga.plant.ReferenceList;
import org.sourceforge.kga.rules.Hint;
import org.sourceforge.kga.rules.HintList;
import org.sourceforge.kga.rules.Rule;
import org.sourceforge.kga.translation.Translation;

public class RotationRepetition
extends Rule {
    private static Logger log = Logger.getLogger(Garden.class.getName());

    @Override
    public void getHints(HintList hintList) {
        Point point;
        int n;
        Garden garden = hintList.getGarden();
        List<Plant> list = garden.getPlants(n = hintList.getYear(), point = hintList.getGrid());
        if (list == null) {
            return;
        }
        for (Plant plant : list) {
            Object object;
            int n2;
            if (plant.isItem()) continue;
            int n3 = plant.lifetime.getRepetitionYears();
            if (n3 != Integer.MAX_VALUE) {
                for (n2 = 1; n2 < n3 && (object = garden.getPlants(n - n2, point)) != null && object.contains(plant); ++n2) {
                }
            }
            object = null;
            int n4 = 0;
            boolean bl = false;
            block2: for (int i = 0; i < plant.lifetime.getRepetitionGap() && !bl; ++i) {
                int n5 = n - n2 - i;
                List<Plant> list2 = garden.getPlants(n5, point);
                if (list2 == null) continue;
                for (Plant plant2 : list2) {
                    if (n3 != Integer.MAX_VALUE && plant2 == plant) {
                        object = plant2;
                        bl = true;
                        n4 = n5;
                        continue block2;
                    }
                    if (plant2.getFamily() != plant.getFamily()) continue;
                    object = plant2;
                    n4 = n5;
                }
            }
            if (object == null) continue;
            hintList.addRotationHint(Hint.Value.BAD, plant, (Plant)object, n4, this);
        }
    }

    @Override
    public String getDescription(Hint hint) {
        Translation translation = Translation.getPreferred();
        StringBuilder stringBuilder = new StringBuilder();
        if (hint.getNeighborPlant() == hint.getCurrentPlant()) {
            stringBuilder.append(translation.rotation_repetition_species());
            stringBuilder.append(" ");
            stringBuilder.append(translation.translate(hint.getCurrentPlant()));
        } else {
            stringBuilder.append(translation.rotation_repetition_family());
            stringBuilder.append(" ");
            stringBuilder.append(translation.translate(hint.getCurrentPlant().getFamily()));
        }
        stringBuilder.append(" ");
        stringBuilder.append(translation.in());
        stringBuilder.append(" ");
        stringBuilder.append(hint.getNeighborYear());
        return stringBuilder.toString();
    }

    @Override
    public void addReferencesToList(Hint hint, ReferenceList referenceList) {
        referenceList.add(hint.getCurrentPlant().lifetime.references);
    }
}

