/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.kga.rules;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.sourceforge.kga.Garden;
import org.sourceforge.kga.Plant;
import org.sourceforge.kga.Point;
import org.sourceforge.kga.plant.ReferenceList;
import org.sourceforge.kga.plant.WeedControl;
import org.sourceforge.kga.rules.Hint;
import org.sourceforge.kga.rules.HintList;
import org.sourceforge.kga.rules.Rule;
import org.sourceforge.kga.translation.Translation;

public class RotationWeedControl
extends Rule {
    private static Logger log = Logger.getLogger(Garden.class.getName());

    @Override
    public void getHints(HintList hintList) {
        Point point;
        int n;
        Garden garden = hintList.getGarden();
        List<Plant> list = garden.getPlants(n = hintList.getYear(), point = hintList.getGrid());
        if (list == null || list.isEmpty()) {
            return;
        }
        List<Plant> list2 = garden.getPlants(n - 1, point);
        if (list2 == null || list2.isEmpty()) {
            return;
        }
        ArrayList<Plant> arrayList = new ArrayList<Plant>();
        WeedControl.Type type = WeedControl.Type.WEEDY;
        for (Plant plant : list2) {
            if (plant.getWeedControl() == null) continue;
            if (plant.getWeedControl().type == WeedControl.Type.CLEAR && type == WeedControl.Type.WEEDY) {
                type = WeedControl.Type.CLEAR;
                arrayList.clear();
            }
            arrayList.add(plant);
        }
        for (Plant plant : list) {
            if (plant.getWeedControl() == null) continue;
            WeedControl.Type type2 = plant.getWeedControl().type;
            for (Plant plant2 : arrayList) {
                if (plant2 == plant || plant2.getFamily() == plant.getFamily()) continue;
                Hint.Value value = type2 != type ? Hint.Value.GOOD : (type2 == WeedControl.Type.WEEDY ? Hint.Value.BAD : Hint.Value.TIP);
                hintList.addRotationHint(value, plant, plant2, n - 1, this);
            }
        }
    }

    @Override
    public String getDescription(Hint hint) {
        Translation translation = Translation.getPreferred();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(hint.getValue() == Hint.Value.GOOD ? translation.rotation_weed_control_good() : translation.rotation_weed_control_bad());
        stringBuilder.append(" ");
        stringBuilder.append(hint.getCurrentPlant().getWeedControl().translate());
        stringBuilder.append(" ");
        stringBuilder.append(translation.rotation_after());
        stringBuilder.append(" ");
        stringBuilder.append(hint.getNeighborPlant().getWeedControl().translate());
        return stringBuilder.toString();
    }

    @Override
    public void addReferencesToList(Hint hint, ReferenceList referenceList) {
        referenceList.add(hint.getNeighborPlant().getWeedControl().references);
        referenceList.add(hint.getCurrentPlant().getWeedControl().references);
    }
}

