<?php // ЮТФ-8
// -----------------------------------------
// News to RSS Class
// by Stanislav Tsymbalov (http://stanislav.tsymbalov.net)
// version 1.1.1 (20100211)
// -----------------------------------------

class newstorss {

	function changerss($str) {
		$str=strip_tags($str);
		//$str=str_replace('"',"'",$str);
		$str=str_replace("\n"," ",$str);
		$str=str_replace("\r"," ",$str);
		$str=str_replace("&ldquo;",'"',$str);
		$str=str_replace("&rdquo;",'"',$str);
		$str=str_replace("&laquo;",'"',$str);
		$str=str_replace("&raquo;",'"',$str);
		$str=str_replace("&nbsp;",' ',$str);
		$str=str_replace("&ndash;",'-',$str);
		$str=html_entity_decode($str);
		//$str=nl2br($str);
		$str=str_replace("&","&amp;",$str);
		$str=str_replace("<","&lt;",$str);
		$str=str_replace(">","&gt;",$str);
		$str=str_replace("'","&apos;",$str);
		$str=str_replace('"',"&quot;",$str);
		//$str=str_replace("«","'",$str);
		//$str=str_replace("»","'",$str);	
		return $str;
	}



	var $title; // Site title
	var $desc; // Site desc or 'News'
	var $server_name; // Site URL
	var $image; // Image for RSS (100x100) address
	var $lang; // Lang or RSS
	var $date; // Last Build Date of RSS
	var $ttl; // 
	var $managingEditor; // Email of Editor
	var $webMaster; // Email of WebMaster
	var $timezone; // Your TimeZone, +0600

	var $news;
	
	var $simrss; // 

	
	function checkvars() {
		if ($this->server_name=='') $this->server_name=$_SERVER['HTTP_HOST'];
		if ($this->lang=='') $this->lang='en';
		if ($this->timezone=='') $this->timezone='+0000';
		if ($this->date=='') $this->date=date("D, j M Y H:i:s").' '.$this->timezone;
		if ($this->ttl=='') $this->ttl=21600;
	}
	
	
	function makerss() {
		$this->checkvars();
		
		$this->simrss='';
		$this->simrss.='<?xml version="1.0" encoding="utf-8" ?>';
		$this->simrss.="\n".'<rss version="2.0">';
		$this->simrss.="\n".'<channel>';
		$this->simrss.="\n".'<title>'.$this->title.'</title>';
		$this->simrss.="\n".'<link>'.$this->server_name.'</link>';
		$this->simrss.="\n".'<description>'.$this->changerss($this->desc).'</description>';

		$this->simrss.="\n".'<language>'.$this->lang.'</language>';
		$this->simrss.="\n".'<pubDate>'.$this->date.'</pubDate>';
		$this->simrss.="\n".'<lastBuildDate>'.$this->date.'</lastBuildDate>';
		$this->simrss.="\n".'<ttl>'.$this->ttl.'</ttl>';

		$this->simrss.="\n".'<generator>Dominanta Core RSS Class</generator>';
		if (isset($this->managingEditor)) $this->simrss.="\n".'<managingEditor>'.$this->managingEditor.'</managingEditor>';
		if (isset($this->webMaster)) $this->simrss.="\n".'<webMaster>'.$this->webMaster.'</webMaster>';

		if (isset($this->news)) {
			for ($i=0; $i<count($this->news); $i++) {
				$this->simrss.="\n".'<item>';
				if (isset($this->news[$i]['title'])) $this->simrss.="\n".'<title>'.$this->changerss($this->news[$i]['title']).'</title>';
				if (isset($this->news[$i]['link'])) {
					$this->simrss.="\n".'<link>'.$this->changerss($this->news[$i]['link']).'</link>';
					$this->simrss.="\n".'<guid isPermaLink="true">'.$this->changerss($this->news[$i]['link']).'</guid>';
				}
				if (isset($this->news[$i]['desc'])) $this->simrss.="\n".'<description>'.$this->changerss($this->news[$i]['desc']).'</description>';
				if (isset($this->news[$i]['author'])) $this->simrss.="\n".'<author>'.$this->news[$i]['author'].'</author>';
				if (isset($this->news[$i]['category'])) $this->simrss.="\n".'<category>'.$this->news[$i]['category'].'</category>';
				if (isset($this->news[$i]['date'])) $this->simrss.="\n".'<pubDate>'.date("D, j M Y H:i:s",$this->news[$i]['date']).' '.$this->timezone.'</pubDate>';
				$this->simrss.="\n".'</item>';
			}
		}


		$this->simrss.="\n".'</channel>';
		$this->simrss.="\n".'</rss>';

		return trim($this->simrss);
	}

}

?>