/*
 * Decompiled with CFR 0.152.
 */
package org.goldang.qaparadigm;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.goldang.qaparadigm.About;
import org.goldang.qaparadigm.Alert;
import org.goldang.qaparadigm.DisplayPanel;
import org.goldang.qaparadigm.Fontset;
import org.goldang.qaparadigm.FullFrame;
import org.goldang.qaparadigm.InfoPanel;
import org.goldang.qaparadigm.InsetPanel;
import org.goldang.qaparadigm.LogFile;
import org.goldang.qaparadigm.Prefs;
import org.goldang.qaparadigm.PrefsDialog;
import org.goldang.qaparadigm.SentenceFile;
import org.goldang.qaparadigm.Sex;
import org.goldang.qaparadigm.Strings;

public class Application
extends JFrame {
    private SentenceFile sentenceFile = null;
    private LogFile logFile = null;
    private InfoPanel myInfoPanel;
    private final Prefs myPrefs;
    private static final int FWIDTH = 24;
    private final JTextField subjectField = new JTextField("", 24);
    private final JTextField subjectAge = new JTextField("", 24);
    private final JTextField subjectDialects = new JTextField("", 24);
    private final JCheckBox subjectLinguist = new JCheckBox(Strings.res(Strings.STUDIED_LINGUISTICS));
    private final JButton goButton = new JButton(Strings.res(Strings.GO));
    private Sex sex = Sex.NONE;
    private final MenuBar myMenuBar = new MenuBar();
    private JMenu myDisplayMenu;

    public Application() {
        super(Strings.res(Strings.TITLE));
        this.myPrefs = new Prefs(this.getClass());
        this.setDefaultCloseOperation(3);
        this.setResizable(true);
        this.setContentPane(new InsetPanel(false));
        this.setJMenuBar(this.myMenuBar);
        this.setLayout(new BoxLayout(this.getContentPane(), 1));
        Dimension size = new Dimension(5, 5);
        this.add(new SubjectInfo());
        this.add(new Box.Filler(size, size, size));
        this.goButton.addActionListener(new GoListener());
        InsetPanel ipanel = new InsetPanel(false);
        ipanel.setLayout(new BoxLayout(ipanel, 0));
        ipanel.add(Box.createGlue());
        ipanel.add(this.goButton);
        this.add(ipanel);
        this.enableDisplay(false);
        this.setPreferredPosition();
        this.pack();
    }

    void quit() {
        this.saveScreenLocation();
        System.exit(0);
    }

    public String getSubjectName() {
        return this.subjectField.getText();
    }

    public int getSubjectAge() {
        try {
            return Integer.parseInt(this.subjectAge.getText());
        }
        catch (Exception e) {
            return 0;
        }
    }

    public Sex getSubjectSex() {
        return this.sex;
    }

    public String getSubjectDialects() {
        return this.subjectDialects.getText();
    }

    public boolean isSubjectLinguist() {
        return this.subjectLinguist.isSelected();
    }

    public void openSentenceFile(File file) {
        this.sentenceFile = new SentenceFile(this, file);
        if (this.allCorrespondingSoundsReadable()) {
            this.enableDisplay(true);
            this.getRootPane().setDefaultButton(this.goButton);
        } else {
            new Alert(Strings.res(Strings.CANT_FIND_ALL_SOUNDS), (Frame)this);
            System.exit(1);
        }
    }

    public String sentenceFileCanonicalPath() {
        try {
            return this.sentenceFile.getCanonicalPath();
        }
        catch (IOException e) {
            System.err.println(e);
            return "";
        }
        catch (SecurityException e) {
            System.err.println(e);
            return "";
        }
    }

    private void setPreferredPosition() {
        this.setLocation(this.myPrefs.getPreferredWinPosition());
    }

    public final Prefs getPrefs() {
        return this.myPrefs;
    }

    public void saveScreenLocation() {
        try {
            Point loc = this.getLocationOnScreen();
            this.myPrefs.setPreferredWinPosition(loc);
        }
        catch (IllegalComponentStateException e) {
            return;
        }
    }

    private void setCurrentDir(File curr) {
        try {
            this.myPrefs.setCurrentDirPath(curr.getCanonicalPath());
        }
        catch (IOException e) {
            return;
        }
    }

    private File getCurrentDir() {
        return new File(this.myPrefs.getCurrentDirPath());
    }

    public void setReadyToStart(boolean b) {
        this.myMenuBar.fileMenu.setEnabled(b);
        if (b) {
            this.removeDisplayMenu();
            this.removeInfoPanel();
        }
    }

    final void enableDisplay(boolean yes) {
        this.goButton.setEnabled(yes);
        this.myMenuBar.goMenu.setEnabled(yes);
    }

    GraphicsDevice[] getScreenDevices() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        return ge.getScreenDevices();
    }

    void addDisplayMenu(JMenu menu) {
        this.myDisplayMenu = menu;
        if (this.myDisplayMenu instanceof JMenu) {
            this.myMenuBar.add(menu);
        }
    }

    void removeDisplayMenu() {
        if (this.myDisplayMenu instanceof JMenu) {
            this.myMenuBar.remove(this.myDisplayMenu);
        }
        this.myDisplayMenu = null;
    }

    private void doExperiment() {
        this.logFile = new LogFile(this, this.sentenceFile.getParentFile());
        try {
            GraphicsDevice[] gdList = this.getScreenDevices();
            int prefDevice = this.prefDisplayDevice();
            GraphicsDevice gd = gdList[prefDevice];
            FullFrame fullFrame = new FullFrame(this, gd);
            DisplayPanel display = fullFrame.getDisplayPanel();
            this.myInfoPanel = new InfoPanel(display);
            if (this.numDisplayDevices() == 1) {
                display.add(this.myInfoPanel);
                this.setVisible(false);
            } else {
                this.addInfoPanel(this.myInfoPanel);
                this.setReadyToStart(false);
                this.enableDisplay(false);
                this.addDisplayMenu(display.makeMenu());
            }
            display.setVisible(true);
            fullFrame.setVisible(true);
        }
        catch (Fontset.SupportException err) {
            new Alert(err, (Frame)this);
            this.resetForNewExperiment();
        }
        catch (Exception err) {
            new Alert(err, (Frame)this);
        }
    }

    public InfoPanel getInfoPanel() {
        return this.myInfoPanel;
    }

    private void addInfoPanel(InfoPanel ip) {
        Dimension size = this.getSize();
        int ipHeight = ip.getHeight();
        this.add(ip);
        this.setSize(size.width, size.height + ipHeight);
        this.myInfoPanel = ip;
    }

    void removeInfoPanel() {
        for (Component c : this.getContentPane().getComponents()) {
            if (!(c instanceof InfoPanel)) continue;
            InfoPanel ip = (InfoPanel)c;
            Dimension size = this.getSize();
            int ipHeight = ip.getHeight();
            this.setSize(size.width, size.height - ipHeight);
            this.remove(ip);
        }
        this.myInfoPanel = null;
    }

    private void userChoosesSentenceFile() {
        JFileChooser fc = new JFileChooser(this.getCurrentDir());
        int status = fc.showOpenDialog(this);
        if (status == 0) {
            this.openSentenceFile(fc.getSelectedFile());
        }
        this.setCurrentDir(fc.getCurrentDirectory());
    }

    private boolean allCorrespondingSoundsReadable() {
        boolean allFound = true;
        SentenceFile.NumberedSentences numberedSentences = this.sentenceFile.getNumberedSentences();
        for (SentenceFile.NumberedSentence s : numberedSentences) {
            File file = this.sentenceFile.getFileForSoundNumber(s.number);
            if (file.canRead()) continue;
            System.err.println(Strings.res(Strings.CANT_READ) + " " + file.getPath());
            allFound = false;
        }
        return allFound;
    }

    SentenceFile getSentenceFile() {
        return this.sentenceFile;
    }

    LogFile getLogFile() {
        return this.logFile;
    }

    int prefDisplayDevice() {
        GraphicsDevice[] gdList = this.getScreenDevices();
        int n = this.myPrefs.displayDeviceNum();
        if (n < gdList.length) {
            return n;
        }
        return gdList.length - 1;
    }

    int numDisplayDevices() {
        return this.getScreenDevices().length;
    }

    public void resetForNewExperiment() {
        this.sentenceFile = null;
        this.logFile = null;
        this.enableDisplay(false);
        this.setReadyToStart(true);
    }

    class GoListener
    implements ActionListener {
        GoListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (Application.this.sentenceFile instanceof SentenceFile) {
                Application.this.doExperiment();
            }
        }
    }

    class AboutListener
    implements ActionListener {
        AboutListener() {
        }

        public void actionPerformed(ActionEvent e) {
            new About(Application.this);
        }
    }

    class PrefsListener
    implements ActionListener {
        PrefsListener() {
        }

        public void actionPerformed(ActionEvent e) {
            new PrefsDialog(Application.this);
        }
    }

    class OpenListener
    implements ActionListener {
        OpenListener() {
        }

        public void actionPerformed(ActionEvent e) {
            Application.this.userChoosesSentenceFile();
        }
    }

    class QuitListener
    implements ActionListener {
        QuitListener() {
        }

        public void actionPerformed(ActionEvent e) {
            Application.this.quit();
        }
    }

    class SexButtons
    extends InsetPanel {
        private final JRadioButton female;
        private final JRadioButton male;

        SexButtons() {
            super(false);
            this.female = new JRadioButton(Strings.res(Strings.FEMALE));
            this.male = new JRadioButton(Strings.res(Strings.MALE));
            this.setLayout(new BoxLayout(this, 0));
            this.add(new JLabel(Strings.res(Strings.SEX)));
            ButtonGroup bg = new ButtonGroup();
            bg.add(this.female);
            this.add(this.female);
            bg.add(this.male);
            this.add(this.male);
            SexListener sl = new SexListener();
            this.female.addActionListener(sl);
            this.male.addActionListener(sl);
        }

        public float getAlignmentX() {
            return 0.0f;
        }

        class SexListener
        implements ActionListener {
            SexListener() {
            }

            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == SexButtons.this.female) {
                    Application.this.sex = Sex.FEMALE;
                } else if (e.getSource() == SexButtons.this.male) {
                    Application.this.sex = Sex.MALE;
                } else {
                    Application.this.sex = Sex.NONE;
                }
            }
        }
    }

    private class SubjectInfo
    extends InsetPanel {
        SubjectInfo() {
            super(true);
            this.addFiller();
            this.addLabel(Strings.NAME);
            this.add(Application.this.subjectField);
            this.addFiller();
            this.addLabel(Strings.AGE);
            this.add(Application.this.subjectAge);
            this.addFiller();
            this.add(new SexButtons());
            this.addFiller();
            this.addLabel(Strings.DIALECTS);
            this.add(Application.this.subjectDialects);
            this.addFiller();
            this.add(Application.this.subjectLinguist);
        }

        private void addLabel(Strings.Key key) {
            JLabel label = new JLabel(Strings.res(key));
            this.add(label);
        }

        private void addFiller() {
            Dimension size = new Dimension(5, 5);
            this.add(new Box.Filler(size, size, size));
        }
    }

    private class MenuBar
    extends JMenuBar {
        public final JMenu fileMenu = new JMenu(Strings.res(Strings.FILE));
        private final JMenuItem goMenu = new JMenuItem(Strings.res(Strings.GO));
        private final int shortcutKey = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();

        MenuBar() {
            String str = Strings.res(Strings.OPEN);
            JMenuItem item = new JMenuItem(str);
            item.setAccelerator(this.accel(79));
            item.addActionListener(new OpenListener());
            this.fileMenu.add(item);
            str = Strings.res(Strings.PREFERENCES_);
            item = new JMenuItem(str);
            item.addActionListener(new PrefsListener());
            this.fileMenu.add(item);
            this.goMenu.setAccelerator(this.accel(71));
            this.goMenu.addActionListener(new GoListener());
            this.fileMenu.add(this.goMenu);
            this.fileMenu.add(new JSeparator());
            str = Strings.res(Strings.QUIT);
            item = new JMenuItem(str);
            item.setAccelerator(this.accel(81));
            item.addActionListener(new QuitListener());
            this.fileMenu.add(item);
            this.add(this.fileMenu);
            str = Strings.res(Strings.HELP);
            JMenu helpMenu = new JMenu(str);
            str = Strings.res(Strings.ABOUT);
            item = new JMenuItem(str);
            item.addActionListener(new AboutListener());
            helpMenu.add(item);
            this.add(helpMenu);
        }

        private KeyStroke accel(int key) {
            return KeyStroke.getKeyStroke(key, this.shortcutKey);
        }
    }
}

