/*
 * Decompiled with CFR 0.152.
 */
package org.goldang.qaparadigm;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import org.goldang.qaparadigm.Alert;
import org.goldang.qaparadigm.Application;
import org.goldang.qaparadigm.FullFrame;
import org.goldang.qaparadigm.GraphicDisplay;
import org.goldang.qaparadigm.InfoPanel;
import org.goldang.qaparadigm.LogFile;
import org.goldang.qaparadigm.SentenceFile;
import org.goldang.qaparadigm.SequenceIndexDialog;
import org.goldang.qaparadigm.SoundFilePlayer;
import org.goldang.qaparadigm.Strings;

abstract class DisplayPanel
extends JPanel {
    private final FullFrame myFrame;
    protected final Application myApp;
    private final SoundFilePlayer myPlayer = new SoundFilePlayer();
    private boolean userPlayedSound = false;
    private boolean iHaventSaidThankYou = true;
    private static final int SHORTCUT = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();

    public DisplayPanel(FullFrame frame) {
        this.myFrame = frame;
        this.myApp = frame.getApp();
        this.enableEvents(16L);
        this.setBackground(Color.WHITE);
        JMenu menu = this.makeMenu();
        JPopupMenu popup = menu.getPopupMenu();
        popup.setInvoker(this);
        this.add(popup);
        LeaveIt layout = new LeaveIt();
        this.setLayout(layout);
    }

    public abstract JPopupMenu getPopupMenu();

    public abstract GraphicDisplay getGraphicDisplay();

    FullFrame getFrame() {
        return this.myFrame;
    }

    int getFrameWidth() {
        return this.myFrame.getWidth();
    }

    InfoPanel getInfoPanel() {
        return this.myApp.getInfoPanel();
    }

    InfoPanel getContainedInfoPanel() {
        for (Component c : this.getComponents()) {
            if (!(c instanceof InfoPanel)) continue;
            return (InfoPanel)c;
        }
        return null;
    }

    void passKeyEvent(KeyEvent e) {
        try {
            this.processKeyEvent(e);
        }
        catch (Exception err) {
            System.err.println(err);
        }
    }

    protected abstract void sizeToFit();

    protected SentenceFile getSentenceFile() {
        return this.myApp.getSentenceFile();
    }

    protected LogFile getLogFile() {
        return this.myApp.getLogFile();
    }

    protected abstract void showStimulus();

    protected void showStimulusIndexed(int n) {
        if (n > 0 && n < this.numberOfSentences() && n != this.sequenceIndex()) {
            this.getSentenceFile().goToSentenceIndexed(n);
            if (this.getInfoPanel() instanceof InfoPanel) {
                this.getInfoPanel().sequenceIndexChanged();
            }
            this.userPlayedSound = false;
            this.showStimulus();
        }
    }

    public void setVisible(boolean b) {
        if (b) {
            this.showStimulus();
            if (this.getInfoPanel() instanceof InfoPanel) {
                this.getInfoPanel().sequenceIndexChanged();
            }
        }
        super.setVisible(b);
    }

    final void showThankYou() {
        new Alert(Strings.res(Strings.FINISHED_THANKYOU), (Frame)this.myFrame);
    }

    public void processMouseEvent(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showPopupMenu(e);
        }
    }

    protected void showPopupMenu(MouseEvent e) {
        JPopupMenu popup = this.getPopupMenu();
        this.add(popup);
        popup.show(e.getComponent(), e.getX(), e.getY());
        popup.setVisible(true);
    }

    public abstract JMenu makeMenu();

    String getCurrentSentence() {
        return this.getSentenceFile().getCurrentSentence();
    }

    protected int getCurrentSentenceNumber() {
        return this.getSentenceFile().getCurrentSentenceNumber();
    }

    int numberOfSentences() {
        return this.getSentenceFile().numberOfSentences();
    }

    protected boolean sentencesAreFinished() {
        return this.getSentenceFile().isFinished();
    }

    final int sequenceIndex() {
        return this.getSentenceFile().sequenceIndex();
    }

    protected void playSoundNumber(int n) {
        File soundFile = this.getSentenceFile().getFileForSoundNumber(n);
        this.myPlayer.play(soundFile, this);
    }

    protected void doNextSentence() {
        if (this.getSentenceFile().moreSentencesYet()) {
            if (this.userPlayedSound) {
                this.getSentenceFile().doNextSentence();
                if (this.getInfoPanel() instanceof InfoPanel) {
                    this.getInfoPanel().sequenceIndexChanged();
                }
                this.userPlayedSound = false;
                this.showStimulus();
            } else {
                new Alert(Strings.res(Strings.PLEASE_PLAY_SOUND), (Frame)this.myFrame);
            }
        } else if (this.iHaventSaidThankYou) {
            this.myApp.removeInfoPanel();
            if (this.getInfoPanel() instanceof InfoPanel) {
                this.getInfoPanel().setVisible(false);
            }
            this.showThankYou();
            this.iHaventSaidThankYou = false;
        } else {
            this.closeDisplayWithoutFinishing();
            this.myApp.resetForNewExperiment();
        }
    }

    protected void doPrevSentence() {
        this.getSentenceFile().doPrevSentence();
        if (this.getInfoPanel() instanceof InfoPanel) {
            this.getInfoPanel().sequenceIndexChanged();
        }
        this.userPlayedSound = false;
        this.showStimulus();
    }

    protected void closeDisplayWithoutFinishing() {
        this.myFrame.setVisible(false);
        this.myApp.removeDisplayMenu();
        this.myApp.removeInfoPanel();
        this.myApp.setVisible(true);
        this.myApp.setReadyToStart(true);
        this.myApp.enableDisplay(true);
    }

    void showProgress(float val) {
        if (this.getInfoPanel() instanceof InfoPanel) {
            this.getInfoPanel().showSoundProgress(val);
        }
    }

    void showFinished() {
        if (this.getInfoPanel() instanceof InfoPanel) {
            this.getInfoPanel().showSoundFinished();
        }
    }

    long getDelayAfterPlayingMillisec() {
        return this.myApp.getPrefs().getDelayAfterPlayingMillisec();
    }

    class Quit
    extends AbstractAction {
        Quit() {
        }

        public void actionPerformed(ActionEvent e) {
            DisplayPanel.this.myApp.quit();
        }
    }

    class CloseDisplay
    extends AbstractAction {
        CloseDisplay() {
        }

        public void actionPerformed(ActionEvent e) {
            DisplayPanel.this.closeDisplayWithoutFinishing();
        }
    }

    class ShowSequenceIndex
    extends AbstractAction {
        ShowSequenceIndex() {
        }

        public void actionPerformed(ActionEvent e) {
            new SequenceIndexDialog(DisplayPanel.this.myFrame);
        }
    }

    class PrevSentence
    extends AbstractAction {
        PrevSentence() {
        }

        public boolean isEnabled() {
            return !DisplayPanel.this.myPlayer.isPlaying() && DisplayPanel.this.sequenceIndex() > 0;
        }

        public void actionPerformed(ActionEvent e) {
            if (this.isEnabled()) {
                DisplayPanel.this.doPrevSentence();
            }
        }
    }

    class NextSentence
    extends AbstractAction {
        NextSentence() {
        }

        public boolean isEnabled() {
            return !DisplayPanel.this.myPlayer.isPlaying();
        }

        public void actionPerformed(ActionEvent e) {
            if (this.isEnabled()) {
                DisplayPanel.this.doNextSentence();
            }
        }
    }

    class PlaySound
    extends AbstractAction {
        PlaySound() {
        }

        public void actionPerformed(ActionEvent e) {
            if (this.isEnabled()) {
                int sn = DisplayPanel.this.getCurrentSentenceNumber();
                DisplayPanel.this.playSoundNumber(sn);
                DisplayPanel.this.userPlayedSound = true;
            }
        }

        public boolean isEnabled() {
            return !DisplayPanel.this.myPlayer.isPlaying() && !DisplayPanel.this.sentencesAreFinished();
        }
    }

    protected class ControlMenu
    extends JMenu {
        ControlMenu() {
            super(Strings.res(Strings.DISPLAY));
            this.add(Strings.PLAY_SOUND, 32, 0, new PlaySound());
            this.add(Strings.NEXT_SENTENCE, 10, 0, new NextSentence());
            this.add(Strings.PREV_SENTENCE, 37, SHORTCUT, new PrevSentence());
            this.add(Strings.SHOW_SENTENCE_NO, 78, SHORTCUT, new ShowSequenceIndex());
            this.add(new JPopupMenu.Separator());
            this.add(Strings.CLOSE_WINDOW, 27, 0, new CloseDisplay());
            this.add(Strings.QUIT, 81, SHORTCUT, new Quit());
        }

        public final JMenuItem add(Strings.Key nameKey, int key, int shortcut, Action action) {
            KeyStroke ks = KeyStroke.getKeyStroke(key, shortcut);
            JMenuItem item = this.add(nameKey, action);
            item.setAccelerator(ks);
            return item;
        }

        public final JMenuItem add(Strings.Key nameKey, Action action) {
            return this.add(nameKey, action, -1);
        }

        public final JMenuItem add(Strings.Key nameKey, Action action, int position) {
            String name = Strings.res(nameKey);
            JMenuItem item = new JMenuItem(name);
            item.addActionListener(action);
            super.add((Component)item, position);
            return item;
        }

        public final Component add(Component c, int position) {
            return super.add(c, position);
        }
    }

    class LeaveIt
    implements LayoutManager {
        private boolean isFirstLayout = true;

        LeaveIt() {
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void layoutContainer(Container parent) {
            Dimension sz = parent.getSize();
            Insets i = parent.getInsets();
            int cx = (sz.width + i.left - i.right) / 2;
            int cy = (sz.height + i.top - i.bottom) / 2;
            if (this.isFirstLayout) {
                DisplayPanel.this.sizeToFit();
                this.isFirstLayout = false;
            }
            Dimension tsz = DisplayPanel.this.getGraphicDisplay().getSize();
            int ix = cx - tsz.width / 2;
            int iy = cy - tsz.height / 2;
            DisplayPanel.this.getGraphicDisplay().setLocation(ix, iy);
            InfoPanel ip = DisplayPanel.this.getContainedInfoPanel();
            if (ip instanceof InfoPanel) {
                ip.setLocation(i.left + 5, sz.height - ip.getHeight() - i.bottom - 5);
            }
        }

        public Dimension minimumLayoutSize(Container parent) {
            return parent.getMinimumSize();
        }

        public Dimension preferredLayoutSize(Container parent) {
            return parent.getPreferredSize();
        }

        public void removeLayoutComponent(Component comp) {
        }
    }
}

