<?php
////////////////////////////////////////////////////////////////////////////
//                                                                        //
// NOTICE OF COPYRIGHT                                                    //
//                                                                        //
// Dean`s Office for Moodle                                               //
// Электронный деканат                                                    //
// <http://deansoffice.ru/>                                               //
//                                                                        //
// Copyright (C) 2008-2999  Alex Djachenko (Алексей Дьяченко)             //
// alex-pub@my-site.ru                                                    //
// Copyright (C) 2008-2999  Evgenij Cigancov (Евгений Цыганцов)           //
// Copyright (C) 2008-2999  Ilia Smirnov (Илья Смирнов)                   // 
// Copyright (C) 2008-2999  Mariya Rojayskaya (Мария Рожайская)           // 
//                                                                        //
// This program is free software: you can redistribute it and/or modify   //
// it under the terms of the GNU General Public License as published by   //
// the Free Software Foundation, either version 3 of the Licensen.        //
//                                                                        //
// This program is distributed in the hope that it will be useful,        //
// but WITHOUT ANY WARRANTY; without even the implied warranty of         //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          //
// GNU General Public License for more details.                           //
//                                                                        //
// You should have received a copy of the GNU General Public License      //
// along with this program.  If not, see <http://www.gnu.org/licenses/>.  //
//                                                                        //
////////////////////////////////////////////////////////////////////////////

// Подключаем библиотеки
require_once('lib.php');
if ( !defined('AJAX_SCRIPT') )
{
    define('AJAX_SCRIPT', true);
}
require_once('form.php');

// Тип учебного плана 'programmsbc', 'agroup'
$type = required_param('type', PARAM_TEXT);
// Нужо ли возвращать форму 
$onlystatus = optional_param('onlystatus', 0, PARAM_BOOL);
$typeid = 0;

// Определим, какой тип учебного плана нужно загружать
if ( $type == 'programmsbc' )
{
    $typeid = required_param('programmsbcid', PARAM_INT);
} else if ( $type == 'agroup' )
{
    $typeid = required_param('agroupid', PARAM_INT);
} else
{// Выведем ошибку - некорректный тип учебного плана
    $errorlink = $DOF->url_im('programmsbcs','/list.php',$addvars);
    $DOF->print_error('error_type', $errorlink, $type, 'im', 'learningplan');
}

// Проверяем полномочия на просмотр и редактирование информации
$DOF->storage('learningplan')->require_access('view');
$DOF->storage('learningplan')->require_access('edit');

$params = array('type' => $type, "{$type}id" => $typeid);

// Проверим существования группы или подписки
if ( ! $DOF->storage($type . 's')->is_exists($typeid) )
{
    $errorlink = $DOF->url_im($type . 's','/list.php',$addvars);
    $DOF->print_error('error_typeid', $errorlink, $type, 'im', 'learningplan');
}

// Подключаем формы
require_once($DOF->plugin_path('im', 'learningplan', '/form.php'));
// Создаем оъект данных для формы
$customdata = new stdClass();
$customdata->dof = $DOF;
$customdata->type = $type;
$customdata->typeid = $typeid;
if ( isset($addvars['departmentid']) )
{
    $customdata->departmentid = $addvars['departmentid'];
} else
{
    $customdata->departmentid = 0;
}
// Объявляем форму
$learningplan = new dof_im_learningplan_edit_form($DOF->url_im('learningplan',
                '/index.php', $addvars + $params), $customdata, 'post', '', array('id'=>'learnplan'));
$status = 'failed';
if ( $learningplan->process(true) )
{
    $status = 'ok';
}
// Если мы отправили что-то с формы, обновим её
if ( $learningplan->is_submitted() AND $learningplan->is_validated() )
{
    $learningplan = new dof_im_learningplan_edit_form($DOF->url_im('learningplan',
                    '/index.php', $addvars + $params), $customdata, 'post', '', array('id'=>'learnplan'));
}
$submitparams = $learningplan->get_submitparams();
$sorted       = $learningplan->get_sorted_pitems();
$agenums      = $learningplan->get_transfer_agenums_all();

// Отображаем индивидуальный учебный план
ob_start();
$learningplan->display();
$outhtmlform = ob_get_clean();

$html = '';
$script = '';
if ( !$onlystatus )
{// Передаём всю форму для отображения
    // First we get the script generated by the Form API
    if (strpos($outhtmlform, '</script>') !== false) {
        $outputparts = explode('</script>', $outhtmlform);
        $html = $outputparts[1];
        $script = str_replace('<script type="text/javascript">', '', $outputparts[0]);
    } else {
        $html = $outhtmlform;
    }
    // Next we get the M.yui.loader call which includes the Javascript libraries
    $headcode = $DOF->modlib('nvg')->get_head_code();
    $loadpos = strpos($headcode, 'M.yui.loader');
    $cfgpos = strpos($headcode, 'M.cfg');
    $script .= substr($headcode, $loadpos, $cfgpos-$loadpos);
    // And finally the initalisation calls for those libraries
    $endcode = $DOF->modlib('nvg')->get_end_code();
    $script .= preg_replace('/<\/?(script|link)[^>]*>/', '', $endcode);
}

echo json_encode(array('html' => $html, 'script' => $script, 'submitparams' => $submitparams,
                       'sorted' => $sorted, 'agenums' => $agenums, 'status' => $status));

?>